/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.boot.autoconfig;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.axonframework.boot.DistributedCommandBusProperties;
import org.axonframework.boot.autoconfig.SpringCloudAutoConfiguration;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.serialization.Serializer;
import org.axonframework.spring.commandhandling.distributed.jgroups.JGroupsConnectorFactoryBean;
import org.jgroups.stack.GossipRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SpringCloudAutoConfiguration.class})
@ConditionalOnExpression(value="${axon.distributed.enabled:false} || ${axon.distributed.jgroups.enabled:false}")
@ConditionalOnClass(name={"org.axonframework.jgroups.commandhandling.JGroupsConnector", "org.jgroups.JChannel"})
public class JGroupsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JGroupsAutoConfiguration.class);
    @Autowired
    private DistributedCommandBusProperties properties;

    @ConditionalOnProperty(value={"axon.distributed.jgroups.gossip.autoStart"})
    @Bean(destroyMethod="stop")
    public GossipRouter gossipRouter() {
        Matcher matcher = Pattern.compile("([^[\\[]]*)\\[(\\d*)\\]").matcher(this.properties.getJgroups().getGossip().getHosts());
        if (matcher.find()) {
            GossipRouter gossipRouter = new GossipRouter(matcher.group(1), Integer.parseInt(matcher.group(2)));
            try {
                gossipRouter.start();
            }
            catch (Exception e) {
                logger.warn("Unable to autostart start embedded Gossip server: {}", (Object)e.getMessage());
            }
            return gossipRouter;
        }
        logger.error("Wrong hosts pattern, cannot start embedded Gossip Router: " + this.properties.getJgroups().getGossip().getHosts());
        return null;
    }

    @ConditionalOnMissingBean(value={CommandRouter.class, CommandBusConnector.class})
    @Bean
    public JGroupsConnectorFactoryBean jgroupsConnectorFactoryBean(Serializer serializer, @Qualifier(value="localSegment") CommandBus localSegment) {
        System.setProperty("jgroups.tunnel.gossip_router_hosts", this.properties.getJgroups().getGossip().getHosts());
        System.setProperty("jgroups.bind_addr", String.valueOf(this.properties.getJgroups().getBindAddr()));
        System.setProperty("jgroups.bind_port", String.valueOf(this.properties.getJgroups().getBindPort()));
        JGroupsConnectorFactoryBean jGroupsConnectorFactoryBean = new JGroupsConnectorFactoryBean();
        jGroupsConnectorFactoryBean.setClusterName(this.properties.getJgroups().getClusterName());
        jGroupsConnectorFactoryBean.setLocalSegment(localSegment);
        jGroupsConnectorFactoryBean.setSerializer(serializer);
        jGroupsConnectorFactoryBean.setConfiguration(this.properties.getJgroups().getConfigurationFile());
        return jGroupsConnectorFactoryBean;
    }
}

