/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.query.QueryRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.axonserver.connector.util.GrpcMetadata;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class GrpcBackedQueryMessage<P, R>
implements QueryMessage {
    private final QueryRequest query;
    private final LazyDeserializingObject<P> serializedPayload;
    private final LazyDeserializingObject<ResponseType<R>> serializedResponseType;
    private final Supplier<Metadata> metadataSupplier;
    private final MessageType type;

    public GrpcBackedQueryMessage(QueryRequest queryRequest, Serializer messageSerializer, Serializer serializer) {
        this(queryRequest, new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryRequest.getPayload()), messageSerializer), new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryRequest.getResponseType()), serializer), new GrpcMetadata(queryRequest.getMetaDataMap(), messageSerializer), new MessageType(queryRequest.getQuery()));
    }

    private GrpcBackedQueryMessage(QueryRequest queryRequest, LazyDeserializingObject<P> serializedPayload, LazyDeserializingObject<ResponseType<R>> serializedResponseType, Supplier<Metadata> metadataSupplier, MessageType type) {
        this.query = queryRequest;
        this.serializedPayload = serializedPayload;
        this.serializedResponseType = serializedResponseType;
        this.metadataSupplier = metadataSupplier;
        this.type = type;
    }

    @Nonnull
    public String identifier() {
        return this.query.getMessageIdentifier();
    }

    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Nonnull
    public ResponseType<R> responseType() {
        return (ResponseType)this.serializedResponseType.getObject();
    }

    @Nullable
    public P payload() {
        return (P)this.serializedPayload.getObject();
    }

    @Nullable
    public <T> T payloadAs(@Nonnull Type type, @Nullable Converter converter) {
        return null;
    }

    @Nonnull
    public Metadata metadata() {
        return this.metadataSupplier.get();
    }

    @Nonnull
    public Class<P> payloadType() {
        return this.serializedPayload.getType();
    }

    @Nonnull
    public GrpcBackedQueryMessage<P, R> withMetadata(@Nonnull Map<String, String> metadata) {
        return new GrpcBackedQueryMessage<P, R>(this.query, this.serializedPayload, this.serializedResponseType, () -> Metadata.from((Map)metadata), this.type);
    }

    @Nonnull
    public GrpcBackedQueryMessage<P, R> andMetadata(@Nonnull Map<String, String> metadata) {
        return this.withMetadata((Map)this.metadata().mergedWith(metadata));
    }

    @Nonnull
    public QueryMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        return null;
    }
}

