/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event;

import io.axoniq.axonserver.grpc.control.EventProcessorInfo;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.eventhandling.processing.EventProcessor;
import org.axonframework.messaging.eventhandling.processing.streaming.StreamingEventProcessor;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.EventTrackerStatus;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessor;

@Internal
final class EventProcessorInfoUtils {
    private static final String POOLED_STREAMING = "Pooled Streaming";
    private static final String SUBSCRIBING = "Subscribing";
    private static final String UNKNOWN = "Unknown";

    @Nonnull
    public static EventProcessorInfo describeStreaming(@Nonnull StreamingEventProcessor streamingProcessor) {
        List segmentStatuses = streamingProcessor.processingStatus().values().stream().map(EventProcessorInfoUtils::buildSegmentStatus).collect(Collectors.toList());
        return EventProcessorInfo.newBuilder().setProcessorName(streamingProcessor.name()).setTokenStoreIdentifier(streamingProcessor.getTokenStoreIdentifier()).setMode(POOLED_STREAMING).setActiveThreads(streamingProcessor.processingStatus().size()).setAvailableThreads(streamingProcessor.maxCapacity() - streamingProcessor.processingStatus().size()).setRunning(streamingProcessor.isRunning()).setError(streamingProcessor.isError()).addAllSegmentStatus(segmentStatuses).setIsStreamingProcessor(true).build();
    }

    private static EventProcessorInfo.SegmentStatus buildSegmentStatus(EventTrackerStatus status) {
        return EventProcessorInfo.SegmentStatus.newBuilder().setSegmentId(status.getSegment().getSegmentId()).setCaughtUp(status.isCaughtUp()).setReplaying(status.isReplaying()).setOnePartOf(status.getSegment().getMask() + 1).setTokenPosition(EventProcessorInfoUtils.getPosition(status.getTrackingToken())).setErrorState(status.isErrorState() ? EventProcessorInfoUtils.buildErrorMessage(status.getError()) : "").build();
    }

    private static long getPosition(TrackingToken trackingToken) {
        long position = 0L;
        if (trackingToken != null) {
            position = trackingToken.position().orElse(0L);
        }
        return position;
    }

    private static String buildErrorMessage(Throwable error) {
        return error.getClass().getName() + ": " + error.getMessage();
    }

    @Nonnull
    public static EventProcessorInfo describeSubscribing(@Nonnull SubscribingEventProcessor subscribingProcessor) {
        return EventProcessorInfo.newBuilder().setProcessorName(subscribingProcessor.name()).setMode(SUBSCRIBING).setIsStreamingProcessor(false).build();
    }

    @Nonnull
    public static EventProcessorInfo describeUnknown(@Nonnull EventProcessor unknownProcessor) {
        return EventProcessorInfo.newBuilder().setProcessorName(unknownProcessor.name()).setMode(UNKNOWN).setIsStreamingProcessor(false).build();
    }

    private EventProcessorInfoUtils() {
    }
}

