/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import io.axoniq.axonserver.connector.event.PersistentStreamProperties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSource;
import org.axonframework.axonserver.connector.event.axon.PersistentStreamMessageSourceFactory;
import org.axonframework.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentStreamMessageSourceFactory
implements PersistentStreamMessageSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPersistentStreamMessageSourceFactory.class);
    private final Set<String> usedNames = new CopyOnWriteArraySet<String>();

    @Override
    public PersistentStreamMessageSource build(String name, PersistentStreamProperties persistentStreamProperties, ScheduledExecutorService scheduler, int batchSize, String context, Configuration configuration) {
        if (!this.usedNames.add(name)) {
            logger.warn("A Persistent Stream connection with Axon Server is uniquely identified based on the name. Another Persistent Stream is started for a given name [{}]. The new connection will overwrite the existing connection.", (Object)name);
        }
        return new PersistentStreamMessageSource(name, configuration, persistentStreamProperties, scheduler, batchSize, context);
    }
}

