/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.connector.Registration;
import io.axoniq.axonserver.connector.command.CommandChannel;
import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.distributed.Connector;
import org.axonframework.commandhandling.distributed.PriorityResolver;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerConnector
implements Connector {
    private final CommandChannel commandChannel;
    private final AtomicReference<BiConsumer<CommandMessage<?>, Connector.ResultCallback>> incomingHandler = new AtomicReference();
    private final Map<String, Registration> subscriptions = new ConcurrentHashMap<String, Registration>();
    private static final Logger logger = LoggerFactory.getLogger(AxonServerConnector.class);

    public AxonServerConnector(CommandChannel commandChannel) {
        this.commandChannel = commandChannel;
    }

    public CompletableFuture<CommandResultMessage<?>> dispatch(CommandMessage<?> command, ProcessingContext processingContext) {
        return this.commandChannel.sendCommand(this.buildCommand(command, processingContext)).thenCompose(this::buildResultMessage);
    }

    private CompletableFuture<CommandResultMessage<?>> buildResultMessage(CommandResponse commandResponse) {
        if (commandResponse.hasErrorMessage()) {
            return CompletableFuture.failedFuture((Throwable)ErrorCode.getFromCode(commandResponse.getErrorCode()).convert(commandResponse.getErrorMessage(), () -> commandResponse.getPayload().getData().isEmpty() ? null : commandResponse.getPayload().getData().toByteArray()));
        }
        return CompletableFuture.completedFuture(new GenericCommandResultMessage((Message)new GenericMessage(commandResponse.getMessageIdentifier(), new MessageType(commandResponse.getPayload().getType(), commandResponse.getPayload().getRevision()), (Object)commandResponse.getPayload().getData().toByteArray(), this.convertMap(commandResponse.getMetaDataMap(), this::convertToMetaDataValue))));
    }

    private Command buildCommand(CommandMessage<?> command, ProcessingContext processingContext) {
        Command.Builder builder = Command.newBuilder();
        if (processingContext != null) {
            if (processingContext.containsResource(RoutingStrategy.ROUTING_KEY)) {
                String routingKey = (String)processingContext.getResource(RoutingStrategy.ROUTING_KEY);
                builder.addProcessingInstructions(AxonServerConnector.createProcessingInstruction(ProcessingKey.ROUTING_KEY, MetaDataValue.newBuilder().setTextValue(routingKey))).build();
            }
            if (processingContext.containsResource(PriorityResolver.PRIORITY_KEY)) {
                long routingKey = ((Integer)processingContext.getResource(PriorityResolver.PRIORITY_KEY)).intValue();
                builder.addProcessingInstructions(AxonServerConnector.createProcessingInstruction(ProcessingKey.PRIORITY, MetaDataValue.newBuilder().setNumberValue(routingKey))).build();
            }
        }
        Object payload = command.getPayload();
        return builder.setMessageIdentifier(command.getIdentifier()).setName(command.type().name()).putAllMetaData(this.convertMap((Map)command.getMetaData(), (Function)this::convertToTextMetaDataValue)).setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])((byte[])payload))).setType(command.type().name()).build()).build();
    }

    private <S, T> Map<String, T> convertMap(Map<String, S> source, Function<S, T> mapper) {
        HashMap result = new HashMap();
        source.forEach((k, v) -> {
            Object convertedValue = mapper.apply(v);
            if (convertedValue != null) {
                result.put(k, convertedValue);
            }
        });
        return result;
    }

    public void subscribe(String commandName, int loadFactor) {
        this.subscriptions.put(commandName, this.commandChannel.registerCommandHandler(this::incoming, loadFactor, new String[]{commandName}));
    }

    private static ProcessingInstruction.Builder createProcessingInstruction(ProcessingKey key, MetaDataValue.Builder value) {
        return ProcessingInstruction.newBuilder().setKey(key).setValue(value);
    }

    private CompletableFuture<CommandResponse> incoming(final Command command) {
        final CompletableFuture<CommandResponse> result = new CompletableFuture<CommandResponse>();
        BiConsumer<CommandMessage<?>, Connector.ResultCallback> handler = this.incomingHandler.get();
        handler.accept(this.convertToCommandMessage(command), new Connector.ResultCallback(){

            public void success(Message<?> resultMessage) {
                result.complete(AxonServerConnector.this.createResult(command, resultMessage));
            }

            public void error(Throwable cause) {
                result.completeExceptionally(cause);
            }
        });
        return result;
    }

    private CommandMessage<?> convertToCommandMessage(Command command) {
        SerializedObject commandPayload = command.getPayload();
        return new GenericCommandMessage((Message)new GenericMessage(command.getMessageIdentifier(), new MessageType(commandPayload.getType(), commandPayload.getRevision()), (Object)commandPayload.getData().toByteArray(), this.convertMap(command.getMetaDataMap(), this::convertToMetaDataValue)));
    }

    protected String convertToMetaDataValue(MetaDataValue value) {
        return switch (value.getDataCase()) {
            case MetaDataValue.DataCase.TEXT_VALUE -> value.getTextValue();
            case MetaDataValue.DataCase.DOUBLE_VALUE -> Double.toString(value.getDoubleValue());
            case MetaDataValue.DataCase.NUMBER_VALUE -> Long.toString(value.getNumberValue());
            case MetaDataValue.DataCase.BOOLEAN_VALUE -> Boolean.toString(value.getBooleanValue());
            default -> null;
        };
    }

    private CommandResponse createResult(Command command, Message<?> result) {
        ResultMessage commandResultMessage;
        CommandResponse.Builder responseBuilder = CommandResponse.newBuilder().setMessageIdentifier((String)ObjectUtils.getOrDefault((Object)result.getIdentifier(), (Object)UUID.randomUUID().toString())).putAllMetaData(this.convertMap((Map)result.getMetaData(), (Function)this::convertToTextMetaDataValue)).setRequestIdentifier(command.getMessageIdentifier());
        if (result instanceof ResultMessage && (commandResultMessage = (ResultMessage)result).isExceptional()) {
            Throwable throwable = commandResultMessage.exceptionResult();
            responseBuilder.setErrorCode(ErrorCode.getCommandExecutionErrorCode(throwable).errorCode());
            responseBuilder.setErrorMessage(ExceptionSerializer.serialize("", throwable));
            Optional optionalDetails = commandResultMessage.exceptionDetails();
            if (optionalDetails.isPresent()) {
                responseBuilder.setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])((byte[])optionalDetails.get())))).build();
            } else {
                logger.warn("Serializing exception [{}] without details.", throwable.getClass(), (Object)throwable);
                logger.info("To share exceptional information with the recipient it is recommended to wrap the exception in a CommandExecutionException with provided details.");
            }
        } else if (result.getPayload() != null) {
            responseBuilder.setPayload(SerializedObject.newBuilder().setData(ByteString.copyFrom((byte[])((byte[])result.getPayload()))));
        }
        return responseBuilder.build();
    }

    protected MetaDataValue convertToTextMetaDataValue(String value) {
        return MetaDataValue.newBuilder().setTextValue(value).build();
    }

    public boolean unsubscribe(String commandName) {
        Registration subscription = this.subscriptions.remove(commandName);
        if (subscription != null) {
            subscription.cancel();
            return true;
        }
        return false;
    }

    public void onIncomingCommand(BiConsumer<CommandMessage<?>, Connector.ResultCallback> handler) {
        this.incomingHandler.set(handler);
    }
}

