/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.event.axon;

import java.util.function.Function;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.event.axon.AxonServerEventStore;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.DefaultEventBusSpanFactory;
import org.axonframework.eventhandling.EventBusSpanFactory;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.SpanFactory;

public class AxonServerEventStoreFactory {
    private final AxonServerEventStore.Builder base;

    protected AxonServerEventStoreFactory(Builder builder) {
        builder.validate();
        this.base = AxonServerEventStore.builder().configuration(builder.configuration).platformConnectionManager(builder.connectionManager).snapshotSerializer(builder.snapshotSerializer).eventSerializer(builder.eventSerializer).upcasterChain(builder.upcasterChain).snapshotFilter(builder.snapshotFilter).messageMonitor(builder.messageMonitor).spanFactory(builder.spanFactory);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AxonServerEventStore constructFor(@Nonnull String context) {
        return this.base.defaultContext(context).build();
    }

    public AxonServerEventStore constructFor(@Nonnull String context, @Nonnull AxonServerEventStoreConfiguration configuration) {
        return ((AxonServerEventStore.Builder)((Object)configuration.apply(this.base.defaultContext(context)))).build();
    }

    @FunctionalInterface
    public static interface AxonServerEventStoreConfiguration
    extends Function<AxonServerEventStore.Builder, AxonServerEventStore.Builder> {
        default public AxonServerEventStoreConfiguration andThen(AxonServerEventStoreConfiguration other) {
            return builder -> (AxonServerEventStore.Builder)((Object)((Object)other.apply(this.apply(builder))));
        }

        public static AxonServerEventStoreConfiguration noOp() {
            return builder -> builder;
        }
    }

    public static class Builder {
        private AxonServerConfiguration configuration;
        private AxonServerConnectionManager connectionManager;
        private Serializer snapshotSerializer;
        private Serializer eventSerializer;
        private EventUpcaster upcasterChain = NoOpEventUpcaster.INSTANCE;
        private SnapshotFilter snapshotFilter;
        private MessageMonitor<? super EventMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private EventBusSpanFactory spanFactory = DefaultEventBusSpanFactory.builder().spanFactory((SpanFactory)NoOpSpanFactory.INSTANCE).build();

        public Builder configuration(@Nonnull AxonServerConfiguration configuration) {
            BuilderUtils.assertNonNull((Object)configuration, (String)"The AxonServerConfiguration may not be null");
            this.configuration = configuration;
            return this;
        }

        public Builder connectionManager(@Nonnull AxonServerConnectionManager connectionManager) {
            BuilderUtils.assertNonNull((Object)connectionManager, (String)"The AxonServerConnectionManager may not be null");
            this.connectionManager = connectionManager;
            return this;
        }

        public Builder snapshotSerializer(@Nonnull Serializer snapshotSerializer) {
            BuilderUtils.assertNonNull((Object)snapshotSerializer, (String)"The Snapshot Serializer may not be null");
            this.snapshotSerializer = snapshotSerializer;
            return this;
        }

        public Builder eventSerializer(@Nonnull Serializer eventSerializer) {
            BuilderUtils.assertNonNull((Object)eventSerializer, (String)"The Event Serializer may not be null");
            this.eventSerializer = eventSerializer;
            return this;
        }

        public Builder snapshotFilter(@Nonnull SnapshotFilter snapshotFilter) {
            BuilderUtils.assertNonNull((Object)snapshotFilter, (String)"The Snapshot filter may not be null");
            this.snapshotFilter = snapshotFilter;
            return this;
        }

        public Builder upcasterChain(@Nonnull EventUpcaster upcasterChain) {
            BuilderUtils.assertNonNull((Object)upcasterChain, (String)"EventUpcaster may not be null");
            this.upcasterChain = upcasterChain;
            return this;
        }

        public Builder messageMonitor(@Nonnull MessageMonitor<? super EventMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, (String)"MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder spanFactory(@Nonnull EventBusSpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"EventBusSpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public AxonServerEventStoreFactory build() {
            return new AxonServerEventStoreFactory(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull((Object)this.configuration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.connectionManager, (String)"The AxonServerConnectionManager is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.snapshotFilter, (String)"The SnapshotFilter is a hard requirement and should be provided");
        }
    }
}

