/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.common.AxonThreadFactory;

@FunctionalInterface
public interface ExecutorServiceBuilder
extends BiFunction<AxonServerConfiguration, BlockingQueue<Runnable>, ExecutorService> {
    public static final long THREAD_KEEP_ALIVE_TIME = 100L;

    public static ExecutorServiceBuilder defaultCommandExecutorServiceBuilder() {
        return (configuration, commandProcessQueue) -> new ThreadPoolExecutor((int)configuration.getCommandThreads(), (int)configuration.getCommandThreads(), 100L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)commandProcessQueue, (ThreadFactory)new AxonThreadFactory("CommandProcessor"));
    }

    public static ExecutorServiceBuilder defaultQueryExecutorServiceBuilder() {
        return (configuration, queryProcessQueue) -> new ThreadPoolExecutor(configuration.getQueryThreads(), configuration.getQueryThreads(), 100L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queryProcessQueue, (ThreadFactory)new AxonThreadFactory("QueryProcessor"));
    }
}

