/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query;

import io.axoniq.axonserver.grpc.MetaDataValue;
import io.axoniq.axonserver.grpc.ProcessingInstruction;
import io.axoniq.axonserver.grpc.ProcessingKey;
import io.axoniq.axonserver.grpc.SerializedObject;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.query.GrpcBackedQueryMessage;
import org.axonframework.axonserver.connector.query.GrpcBackedResponseMessage;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.GrpcMetaDataConverter;
import org.axonframework.axonserver.connector.util.GrpcMetadataSerializer;
import org.axonframework.axonserver.connector.util.GrpcObjectSerializer;
import org.axonframework.axonserver.connector.util.GrpcPayloadSerializer;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.responsetypes.ConvertingResponseMessage;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.serialization.Serializer;

public class QuerySerializer {
    private final Serializer messageSerializer;
    private final Serializer serializer;
    private final AxonServerConfiguration configuration;
    private final GrpcObjectSerializer<Object> exceptionDetailsSerializer;
    private final GrpcPayloadSerializer payloadSerializer;
    private final GrpcMetadataSerializer metadataSerializer;
    private final GrpcObjectSerializer<Object> responseTypeSerializer;

    public QuerySerializer(Serializer messageSerializer, Serializer serializer, AxonServerConfiguration configuration) {
        this.messageSerializer = messageSerializer;
        this.serializer = serializer;
        this.configuration = configuration;
        this.payloadSerializer = new GrpcPayloadSerializer(messageSerializer);
        this.exceptionDetailsSerializer = new GrpcObjectSerializer(messageSerializer);
        this.metadataSerializer = new GrpcMetadataSerializer(new GrpcMetaDataConverter(this.messageSerializer));
        this.responseTypeSerializer = new GrpcObjectSerializer(serializer);
    }

    public <Q, R> QueryRequest serializeRequest(QueryMessage<Q, R> queryMessage, int nrResults, long timeout, int priority) {
        return QueryRequest.newBuilder().setTimestamp(System.currentTimeMillis()).setMessageIdentifier(queryMessage.getIdentifier()).setQuery(queryMessage.getQueryName()).setClientId(this.configuration.getClientId()).setComponentName(this.configuration.getComponentName()).setResponseType((SerializedObject)this.responseTypeSerializer.apply((Object)queryMessage.getResponseType().forSerialization())).setPayload(this.payloadSerializer.apply((Message)queryMessage)).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.NR_OF_RESULTS).setValue(MetaDataValue.newBuilder().setNumberValue(nrResults))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.TIMEOUT).setValue(MetaDataValue.newBuilder().setNumberValue(timeout))).addProcessingInstructions(ProcessingInstruction.newBuilder().setKey(ProcessingKey.PRIORITY).setValue(MetaDataValue.newBuilder().setNumberValue(priority))).putAllMetaData(this.metadataSerializer.apply(queryMessage.getMetaData())).build();
    }

    public QueryResponse serializeResponse(QueryResponseMessage<?> queryResponse, String requestMessageId) {
        QueryResponse.Builder responseBuilder = QueryResponse.newBuilder();
        if (queryResponse.isExceptional()) {
            Throwable exceptionResult = queryResponse.exceptionResult();
            responseBuilder.setErrorCode(ErrorCode.QUERY_EXECUTION_ERROR.errorCode());
            responseBuilder.setErrorMessage(ExceptionSerializer.serialize(this.configuration.getClientId(), exceptionResult));
            queryResponse.exceptionDetails().ifPresent(details -> responseBuilder.setPayload((SerializedObject)this.exceptionDetailsSerializer.apply(details)));
        } else {
            responseBuilder.setPayload(this.payloadSerializer.apply((Message)queryResponse));
        }
        return responseBuilder.putAllMetaData(this.metadataSerializer.apply(queryResponse.getMetaData())).setMessageIdentifier(queryResponse.getIdentifier()).setRequestIdentifier(requestMessageId).build();
    }

    public <Q, R> QueryMessage<Q, R> deserializeRequest(QueryRequest queryRequest) {
        return new GrpcBackedQueryMessage(queryRequest, this.messageSerializer, this.serializer);
    }

    public <R> QueryResponseMessage<R> deserializeResponse(QueryResponse queryResponse, ResponseType<R> expectedResponseType) {
        return new ConvertingResponseMessage(expectedResponseType, new GrpcBackedResponseMessage(queryResponse, this.messageSerializer));
    }
}

