/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor.schedule;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.axonserver.connector.processor.EventProcessorInfoSource;
import org.axonframework.lifecycle.ShutdownHandler;
import org.axonframework.lifecycle.StartHandler;

public class ScheduledEventProcessorInfoSource
implements EventProcessorInfoSource {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final int initialDelay;
    private final int schedulingPeriod;
    private final EventProcessorInfoSource delegate;

    public ScheduledEventProcessorInfoSource(int initialDelay, int schedulingPeriod, EventProcessorInfoSource delegate) {
        this.initialDelay = initialDelay;
        this.schedulingPeriod = schedulingPeriod;
        this.delegate = delegate;
    }

    @StartHandler(phase=0x40000009)
    public void start() {
        this.scheduler.scheduleAtFixedRate(this::notifyInformation, this.initialDelay, this.schedulingPeriod, TimeUnit.MILLISECONDS);
    }

    @Override
    public void notifyInformation() {
        try {
            this.delegate.notifyInformation();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ShutdownHandler(phase=0x40000009)
    public void shutdown() {
        this.scheduler.shutdown();
    }
}

