/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResubscribableStreamObserver<V>
implements StreamObserver<V> {
    private static final Logger logger = LoggerFactory.getLogger(ResubscribableStreamObserver.class);
    private final StreamObserver<V> delegate;
    private final Consumer<Throwable> resubscribe;

    public ResubscribableStreamObserver(StreamObserver<V> delegate, Consumer<Throwable> resubscribe) {
        this.delegate = delegate;
        this.resubscribe = resubscribe;
    }

    public void onNext(V value) {
        try {
            this.delegate.onNext(value);
        }
        catch (OutOfDirectMemoryError | Exception e) {
            this.onError(e);
        }
    }

    public void onError(Throwable throwable) {
        logger.warn("A problem occurred in the stream.", throwable);
        this.delegate.onError(throwable);
        if (throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode().equals((Object)Status.UNAVAILABLE.getCode())) {
            return;
        }
        logger.info("Resubscribing.");
        this.resubscribe.accept(throwable);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }
}

