/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.processor;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.TrackingEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorController {
    private static final Logger logger = LoggerFactory.getLogger(EventProcessorController.class);
    private final EventProcessingConfiguration eventProcessingConfiguration;
    private final Deque<Consumer<String>> pauseHandlers = new ArrayDeque<Consumer<String>>();
    private final Deque<Consumer<String>> startHandlers = new ArrayDeque<Consumer<String>>();

    public EventProcessorController(EventProcessingConfiguration eventProcessingConfiguration) {
        this.eventProcessingConfiguration = eventProcessingConfiguration;
    }

    EventProcessor getEventProcessor(String processorName) {
        return (EventProcessor)this.eventProcessingConfiguration.eventProcessor(processorName).orElseThrow(() -> new RuntimeException("Processor [" + processorName + "] not found"));
    }

    void pauseProcessor(String processorName) {
        this.getEventProcessor(processorName).shutDown();
        this.pauseHandlers.forEach(consumer -> consumer.accept(processorName));
    }

    void startProcessor(String processorName) {
        this.getEventProcessor(processorName).start();
        this.startHandlers.forEach(consumer -> consumer.accept(processorName));
    }

    void releaseSegment(String processorName, int segmentId) {
        EventProcessor eventProcessor = this.getEventProcessor(processorName);
        if (!(eventProcessor instanceof TrackingEventProcessor)) {
            logger.info("Release segment requested for processor [{}] which is not a Tracking Event Processor", (Object)processorName);
            return;
        }
        ((TrackingEventProcessor)eventProcessor).releaseSegment(segmentId);
    }

    boolean splitSegment(String processorName, int segmentId) {
        EventProcessor eventProcessor = this.getEventProcessor(processorName);
        if (!(eventProcessor instanceof TrackingEventProcessor)) {
            logger.info("Split segment requested for processor [{}] which is not a Tracking Event Processor", (Object)processorName);
            return false;
        }
        return (Boolean)((CompletableFuture)((TrackingEventProcessor)eventProcessor).splitSegment(segmentId).thenApply(result -> {
            if (result.booleanValue()) {
                logger.info("Successfully split segment [{}] of processor [{}]", (Object)segmentId, (Object)processorName);
            } else {
                logger.warn("Was not able to split segment [{}] for processor [{}]", (Object)segmentId, (Object)processorName);
            }
            return result;
        })).join();
    }

    boolean mergeSegment(String processorName, int segmentId) {
        EventProcessor eventProcessor = this.getEventProcessor(processorName);
        if (!(eventProcessor instanceof TrackingEventProcessor)) {
            logger.warn("Merge segment request received for processor [{}] which is not a Tracking Event Processor", (Object)processorName);
            return false;
        }
        return (Boolean)((CompletableFuture)((TrackingEventProcessor)eventProcessor).mergeSegment(segmentId).thenApply(result -> {
            if (result.booleanValue()) {
                logger.info("Successfully merged segment [{}] of processor [{}]", (Object)segmentId, (Object)processorName);
            } else {
                logger.warn("Was not able to merge segment [{}] for processor [{}]", (Object)segmentId, (Object)processorName);
            }
            return result;
        })).join();
    }

    public void onPause(Consumer<String> pauseHandler) {
        this.pauseHandlers.add(pauseHandler);
    }

    public void onStart(Consumer<String> startHandler) {
        this.startHandlers.add(startHandler);
    }
}

