/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.command;

import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.command.Command;
import io.axoniq.axonserver.grpc.command.CommandProviderInbound;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandResponse;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.command.CommandSubscription;
import io.grpc.stub.StreamObserver;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.axonserver.connector.DefaultHandlers;
import org.axonframework.axonserver.connector.DefaultInstructionAckSource;
import org.axonframework.axonserver.connector.DispatchInterceptors;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.Handlers;
import org.axonframework.axonserver.connector.InstructionAckSource;
import org.axonframework.axonserver.connector.TargetContextResolver;
import org.axonframework.axonserver.connector.command.AxonServerRegistration;
import org.axonframework.axonserver.connector.command.CommandPriorityCalculator;
import org.axonframework.axonserver.connector.command.CommandSerializer;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.axonserver.connector.util.ExecutorServiceBuilder;
import org.axonframework.axonserver.connector.util.FlowControllingStreamObserver;
import org.axonframework.axonserver.connector.util.ProcessingInstructionHelper;
import org.axonframework.axonserver.connector.util.ResubscribableStreamObserver;
import org.axonframework.axonserver.connector.util.UpstreamAwareStreamObserver;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.callbacks.NoOpCallback;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.messaging.Distributed;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AxonServerCommandBus
implements CommandBus,
Distributed<CommandBus> {
    private static final Logger logger = LoggerFactory.getLogger(AxonServerCommandBus.class);
    private final AxonServerConnectionManager axonServerConnectionManager;
    private final AxonServerConfiguration configuration;
    private final CommandBus localSegment;
    private final CommandSerializer serializer;
    private final RoutingStrategy routingStrategy;
    private final CommandPriorityCalculator priorityCalculator;
    private final CommandProcessor commandProcessor;
    private final DispatchInterceptors<CommandMessage<?>> dispatchInterceptors;
    private final TargetContextResolver<? super CommandMessage<?>> targetContextResolver;
    private final CommandCallback<Object, Object> defaultCommandCallback;
    private final Handlers<CommandProviderInbound.RequestCase, BiConsumer<CommandProviderInbound, StreamObserver<CommandProviderOutbound>>> commandHandlers = new DefaultHandlers<CommandProviderInbound.RequestCase, BiConsumer<CommandProviderInbound, StreamObserver<CommandProviderOutbound>>>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public AxonServerCommandBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, CommandBus localSegment, Serializer serializer, RoutingStrategy routingStrategy) {
        this(axonServerConnectionManager, configuration, localSegment, serializer, routingStrategy, CommandPriorityCalculator.defaultCommandPriorityCalculator());
    }

    @Deprecated
    public AxonServerCommandBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, CommandBus localSegment, Serializer serializer, RoutingStrategy routingStrategy, CommandPriorityCalculator priorityCalculator) {
        this(axonServerConnectionManager, configuration, localSegment, serializer, routingStrategy, priorityCalculator, c -> configuration.getContext());
    }

    @Deprecated
    public AxonServerCommandBus(AxonServerConnectionManager axonServerConnectionManager, AxonServerConfiguration configuration, CommandBus localSegment, Serializer serializer, RoutingStrategy routingStrategy, CommandPriorityCalculator priorityCalculator, TargetContextResolver<? super CommandMessage<?>> targetContextResolver) {
        this.axonServerConnectionManager = axonServerConnectionManager;
        this.configuration = configuration;
        this.localSegment = localSegment;
        this.serializer = new CommandSerializer(serializer, configuration);
        this.routingStrategy = routingStrategy;
        this.priorityCalculator = priorityCalculator;
        String context = configuration.getContext();
        this.targetContextResolver = targetContextResolver.orElse(m -> context);
        this.defaultCommandCallback = NoOpCallback.INSTANCE;
        this.commandProcessor = new CommandProcessor(context, configuration, ExecutorServiceBuilder.defaultCommandExecutorServiceBuilder(), so -> so.getRequestStream(), new DefaultInstructionAckSource<CommandProviderOutbound>(ack -> CommandProviderOutbound.newBuilder().setAck((InstructionAck)ack).build()));
        this.dispatchInterceptors = new DispatchInterceptors();
        this.axonServerConnectionManager.addReconnectListener(context, this::resubscribe);
        this.axonServerConnectionManager.addDisconnectListener(context, this::unsubscribe);
    }

    public AxonServerCommandBus(Builder builder) {
        builder.validate();
        this.axonServerConnectionManager = builder.axonServerConnectionManager;
        this.configuration = builder.configuration;
        this.localSegment = builder.localSegment;
        this.serializer = builder.buildSerializer();
        this.routingStrategy = builder.routingStrategy;
        this.priorityCalculator = builder.priorityCalculator;
        this.defaultCommandCallback = builder.defaultCommandCallback;
        String context = this.configuration.getContext();
        this.targetContextResolver = builder.targetContextResolver.orElse(m -> context);
        this.commandProcessor = new CommandProcessor(context, this.configuration, builder.executorServiceBuilder, builder.requestStreamFactory, builder.instructionAckSource);
        this.dispatchInterceptors = new DispatchInterceptors();
        this.axonServerConnectionManager.addReconnectListener(context, this::resubscribe);
        this.axonServerConnectionManager.addDisconnectListener(context, this::unsubscribe);
    }

    private void resubscribe() {
        this.commandProcessor.resubscribe();
    }

    private void unsubscribe() {
        this.commandProcessor.unsubscribeAll();
    }

    public <C> void dispatch(CommandMessage<C> command) {
        this.dispatch(command, this.defaultCommandCallback);
    }

    public <C, R> void dispatch(CommandMessage<C> commandMessage, CommandCallback<? super C, ? super R> commandCallback) {
        logger.debug("Dispatch command [{}] with callback", (Object)commandMessage.getCommandName());
        this.doDispatch(this.dispatchInterceptors.intercept(commandMessage), commandCallback);
    }

    private <C, R> void doDispatch(final CommandMessage<C> commandMessage, final CommandCallback<? super C, ? super R> commandCallback) {
        final AtomicBoolean serverResponded = new AtomicBoolean(false);
        try {
            String context = this.targetContextResolver.resolveContext(commandMessage);
            Command command = this.serializer.serialize(commandMessage, this.routingStrategy.getRoutingKey(commandMessage), this.priorityCalculator.determinePriority(commandMessage));
            CommandServiceGrpc.newStub(this.axonServerConnectionManager.getChannel(context)).dispatch(command, new StreamObserver<CommandResponse>(){

                public void onNext(CommandResponse commandResponse) {
                    serverResponded.set(true);
                    logger.debug("Received command response [{}]", (Object)commandResponse);
                    try {
                        CommandResultMessage resultMessage = AxonServerCommandBus.this.serializer.deserialize(commandResponse);
                        commandCallback.onResult(commandMessage, resultMessage);
                    }
                    catch (Exception ex) {
                        commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ex));
                        logger.info("Failed to deserialize payload [{}] - Cause: {}", (Object)commandResponse.getPayload().getData(), (Object)ex.getCause().getMessage());
                    }
                }

                public void onError(Throwable throwable) {
                    serverResponded.set(true);
                    commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(AxonServerCommandBus.this.configuration.getClientId(), throwable)));
                }

                public void onCompleted() {
                    if (!serverResponded.get()) {
                        ErrorMessage errorMessage = ErrorMessage.newBuilder().setMessage("No result from command executor").build();
                        commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(errorMessage)));
                    }
                }
            });
        }
        catch (Exception e) {
            logger.debug("There was a problem dispatching command [{}].", commandMessage, (Object)e);
            commandCallback.onResult(commandMessage, GenericCommandResultMessage.asCommandResultMessage((Throwable)ErrorCode.COMMAND_DISPATCH_ERROR.convert(this.configuration.getClientId(), e)));
        }
    }

    public Registration subscribe(String commandName, MessageHandler<? super CommandMessage<?>> messageHandler) {
        logger.debug("Subscribing command with name [{}]", (Object)commandName);
        Registration registration = this.localSegment.subscribe(commandName, messageHandler);
        this.commandProcessor.subscribe(commandName);
        return new AxonServerRegistration(registration, () -> this.commandProcessor.unsubscribe(commandName));
    }

    public CommandBus localSegment() {
        return this.localSegment;
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.localSegment.registerHandlerInterceptor(handlerInterceptor);
    }

    public void disconnect() {
        if (this.commandProcessor != null) {
            this.commandProcessor.disconnect();
        }
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        return this.dispatchInterceptors.registerDispatchInterceptor(dispatchInterceptor);
    }

    private class CommandProcessor {
        private static final int COMMAND_QUEUE_CAPACITY = 1000;
        private static final int DEFAULT_PRIORITY = 0;
        private final String context;
        private final CopyOnWriteArraySet<String> subscribedCommands;
        private final ExecutorService commandExecutor;
        private final Function<UpstreamAwareStreamObserver<CommandProviderInbound>, StreamObserver<CommandProviderOutbound>> requestStreamFactory;
        private final InstructionAckSource<CommandProviderOutbound> instructionAckSource;
        private volatile boolean subscribing;
        private volatile boolean running = true;
        private volatile StreamObserver<CommandProviderOutbound> subscriberStreamObserver;

        CommandProcessor(String context, AxonServerConfiguration configuration, ExecutorServiceBuilder executorServiceBuilder, Function<UpstreamAwareStreamObserver<CommandProviderInbound>, StreamObserver<CommandProviderOutbound>> requestStreamFactory, InstructionAckSource<CommandProviderOutbound> instructionAckSource) {
            this.context = context;
            this.instructionAckSource = instructionAckSource;
            this.subscribedCommands = new CopyOnWriteArraySet();
            PriorityBlockingQueue<Runnable> commandProcessQueue = new PriorityBlockingQueue<Runnable>(1000, Comparator.comparingLong(r -> r instanceof CommandProcessingTask ? ((CommandProcessingTask)r).getPriority() : 0L));
            this.commandExecutor = (ExecutorService)executorServiceBuilder.apply(configuration, commandProcessQueue);
            this.requestStreamFactory = requestStreamFactory;
            AxonServerCommandBus.this.commandHandlers.register(CommandProviderInbound.RequestCase.COMMAND, (inbound, stream) -> {
                this.commandExecutor.execute(new CommandProcessingTask(inbound.getCommand()));
                instructionAckSource.sendSuccessfulAck(inbound.getInstructionId(), (StreamObserver<CommandProviderOutbound>)stream);
            });
            AxonServerCommandBus.this.commandHandlers.register(CommandProviderInbound.RequestCase.ACK, (inbound, stream) -> {
                if (this.isUnsupportedInstructionErrorResult(inbound.getAck())) {
                    logger.warn("Unsupported command instruction sent to the server. {}", (Object)inbound.getAck());
                } else {
                    logger.trace("Received command ack: {}.", (Object)inbound.getAck());
                }
            });
        }

        private boolean isUnsupportedInstructionErrorResult(InstructionAck instructionResult) {
            return instructionResult.hasError() && instructionResult.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.errorCode());
        }

        private void resubscribe() {
            if (this.subscribedCommands.isEmpty() || this.subscribing) {
                return;
            }
            logger.info("Resubscribing Command handlers with AxonServer");
            try {
                StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver(this.context);
                this.subscribedCommands.forEach(command -> outboundStreamObserver.onNext((Object)CommandProviderOutbound.newBuilder().setSubscribe(CommandSubscription.newBuilder().setCommand((String)command).setComponentName(AxonServerCommandBus.this.configuration.getComponentName()).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build()));
            }
            catch (Exception e) {
                logger.warn("Error while resubscribing - [{}]", (Object)e.getMessage());
            }
        }

        public void subscribe(String commandName) {
            this.subscribing = true;
            this.subscribedCommands.add(commandName);
            try {
                StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver(this.context);
                outboundStreamObserver.onNext((Object)CommandProviderOutbound.newBuilder().setSubscribe(CommandSubscription.newBuilder().setCommand(commandName).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setComponentName(AxonServerCommandBus.this.configuration.getComponentName()).setMessageId(UUID.randomUUID().toString()).build()).build());
            }
            catch (Exception e) {
                logger.debug("Subscribing command with name [{}] to Axon Server failed. Will resubscribe when connection is established.", (Object)commandName, (Object)e);
            }
            finally {
                this.subscribing = false;
            }
        }

        private void processCommand(Command command) {
            StreamObserver<CommandProviderOutbound> outboundStreamObserver = this.getSubscriberObserver(this.context);
            try {
                this.dispatchLocal(AxonServerCommandBus.this.serializer.deserialize(command), outboundStreamObserver);
            }
            catch (RuntimeException throwable) {
                logger.error("Error while dispatching command [{}] - Cause: {}", new Object[]{command.getName(), throwable.getMessage(), throwable});
                if (outboundStreamObserver == null) {
                    return;
                }
                CommandProviderOutbound response = CommandProviderOutbound.newBuilder().setCommandResponse(CommandResponse.newBuilder().setMessageIdentifier(UUID.randomUUID().toString()).setRequestIdentifier(command.getMessageIdentifier()).setErrorCode(ErrorCode.COMMAND_DISPATCH_ERROR.errorCode()).setErrorMessage(ExceptionSerializer.serialize(AxonServerCommandBus.this.configuration.getClientId(), throwable))).build();
                outboundStreamObserver.onNext((Object)response);
            }
        }

        private synchronized StreamObserver<CommandProviderOutbound> getSubscriberObserver(String context) {
            if (this.subscriberStreamObserver != null) {
                return this.subscriberStreamObserver;
            }
            UpstreamAwareStreamObserver<CommandProviderInbound> commandsFromRoutingServer = new UpstreamAwareStreamObserver<CommandProviderInbound>(){

                public void onNext(CommandProviderInbound commandToSubscriber) {
                    logger.debug("Received command from server: {}", (Object)commandToSubscriber);
                    CommandProviderInbound.RequestCase requestCase = commandToSubscriber.getRequestCase();
                    Set<BiConsumer<CommandProviderInbound, StreamObserver>> defaultHandlers = Collections.singleton((cpi, stream) -> CommandProcessor.this.instructionAckSource.sendUnsupportedInstruction(cpi.getInstructionId(), AxonServerCommandBus.this.configuration.getClientId(), (StreamObserver)CommandProcessor.this.requestStreamFactory.apply(this)));
                    AxonServerCommandBus.this.commandHandlers.getOrDefault(AxonServerCommandBus.this.configuration.getContext(), requestCase, defaultHandlers).forEach(handler -> handler.accept(commandToSubscriber, CommandProcessor.this.requestStreamFactory.apply(this)));
                }

                public void onError(Throwable ex) {
                    logger.warn("Command Inbound Stream closed with error", ex);
                    CommandProcessor.this.subscriberStreamObserver = null;
                }

                public void onCompleted() {
                    logger.info("Received completed from server.");
                    CommandProcessor.this.subscriberStreamObserver = null;
                }
            };
            ResubscribableStreamObserver<CommandProviderInbound> resubscribableStreamObserver = new ResubscribableStreamObserver<CommandProviderInbound>((StreamObserver<CommandProviderInbound>)commandsFromRoutingServer, t -> this.resubscribe());
            StreamObserver<CommandProviderOutbound> streamObserver = AxonServerCommandBus.this.axonServerConnectionManager.getCommandStream(context, resubscribableStreamObserver);
            logger.info("Creating new command stream subscriber");
            this.subscriberStreamObserver = new FlowControllingStreamObserver<CommandProviderOutbound>(streamObserver, AxonServerCommandBus.this.configuration, flowControl -> CommandProviderOutbound.newBuilder().setFlowControl((FlowControl)flowControl).build(), t -> t.getRequestCase().equals((Object)CommandProviderOutbound.RequestCase.COMMAND_RESPONSE)).sendInitialPermits();
            return this.subscriberStreamObserver;
        }

        public void unsubscribe(String command) {
            this.subscribedCommands.remove(command);
            try {
                this.getSubscriberObserver(this.context).onNext((Object)CommandProviderOutbound.newBuilder().setUnsubscribe(CommandSubscription.newBuilder().setCommand(command).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void unsubscribeAll() {
            for (String subscribedCommand : this.subscribedCommands) {
                try {
                    this.getSubscriberObserver(this.context).onNext((Object)CommandProviderOutbound.newBuilder().setUnsubscribe(CommandSubscription.newBuilder().setCommand(subscribedCommand).setClientId(AxonServerCommandBus.this.configuration.getClientId()).setMessageId(UUID.randomUUID().toString()).build()).build());
                }
                catch (Exception exception) {}
            }
            this.subscriberStreamObserver = null;
        }

        private <C> void dispatchLocal(CommandMessage<C> command, StreamObserver<CommandProviderOutbound> responseObserver) {
            logger.debug("Dispatch command [{}] locally", (Object)command.getCommandName());
            AxonServerCommandBus.this.localSegment.dispatch(command, (commandMessage, commandResultMessage) -> {
                logger.debug("Dispatched command [{}] locally", (Object)command.getCommandName());
                responseObserver.onNext((Object)AxonServerCommandBus.this.serializer.serialize(commandResultMessage, command.getIdentifier()));
            });
        }

        void disconnect() {
            if (this.subscriberStreamObserver != null) {
                this.subscriberStreamObserver.onCompleted();
            }
            this.running = false;
            this.commandExecutor.shutdown();
        }

        private class CommandProcessingTask
        implements Runnable {
            private final long priority;
            private final Command command;

            private CommandProcessingTask(Command command) {
                this.priority = -ProcessingInstructionHelper.priority(command.getProcessingInstructionsList());
                this.command = command;
            }

            public long getPriority() {
                return this.priority;
            }

            @Override
            public void run() {
                if (!CommandProcessor.this.running) {
                    logger.debug("Command Processor has stopped running, hence command [{}] will no longer be processed", (Object)this.command.getName());
                    return;
                }
                try {
                    logger.debug("Will process command: {}", (Object)this.command);
                    CommandProcessor.this.processCommand(this.command);
                }
                catch (OutOfDirectMemoryError | RuntimeException e) {
                    logger.warn("Command Processor had an exception when processing command [{}]", (Object)this.command, (Object)e);
                }
            }
        }
    }

    public static class Builder {
        private CommandCallback<Object, Object> defaultCommandCallback = NoOpCallback.INSTANCE;
        private AxonServerConnectionManager axonServerConnectionManager;
        private AxonServerConfiguration configuration;
        private CommandBus localSegment;
        private Serializer serializer;
        private RoutingStrategy routingStrategy;
        private CommandPriorityCalculator priorityCalculator = CommandPriorityCalculator.defaultCommandPriorityCalculator();
        private TargetContextResolver<? super CommandMessage<?>> targetContextResolver = c -> this.configuration.getContext();
        private ExecutorServiceBuilder executorServiceBuilder = ExecutorServiceBuilder.defaultCommandExecutorServiceBuilder();
        private Function<UpstreamAwareStreamObserver<CommandProviderInbound>, StreamObserver<CommandProviderOutbound>> requestStreamFactory = so -> so.getRequestStream();
        private InstructionAckSource<CommandProviderOutbound> instructionAckSource = new DefaultInstructionAckSource<CommandProviderOutbound>(ack -> CommandProviderOutbound.newBuilder().setAck((InstructionAck)ack).build());

        public Builder axonServerConnectionManager(AxonServerConnectionManager axonServerConnectionManager) {
            BuilderUtils.assertNonNull((Object)axonServerConnectionManager, (String)"AxonServerConnectionManager may not be null");
            this.axonServerConnectionManager = axonServerConnectionManager;
            return this;
        }

        public Builder configuration(AxonServerConfiguration configuration) {
            BuilderUtils.assertNonNull((Object)configuration, (String)"AxonServerConfiguration may not be null");
            this.configuration = configuration;
            return this;
        }

        public Builder localSegment(CommandBus localSegment) {
            BuilderUtils.assertNonNull((Object)localSegment, (String)"Local CommandBus may not be null");
            this.localSegment = localSegment;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder routingStrategy(RoutingStrategy routingStrategy) {
            BuilderUtils.assertNonNull((Object)routingStrategy, (String)"RoutingStrategy may not be null");
            this.routingStrategy = routingStrategy;
            return this;
        }

        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            this.defaultCommandCallback = (CommandCallback)ObjectUtils.getOrDefault(defaultCommandCallback, (Object)NoOpCallback.INSTANCE);
            return this;
        }

        public Builder priorityCalculator(CommandPriorityCalculator priorityCalculator) {
            BuilderUtils.assertNonNull((Object)priorityCalculator, (String)"CommandPriorityCalculator may not be null");
            this.priorityCalculator = priorityCalculator;
            return this;
        }

        public Builder targetContextResolver(TargetContextResolver<? super CommandMessage<?>> targetContextResolver) {
            BuilderUtils.assertNonNull(targetContextResolver, (String)"TargetContextResolver may not be null");
            this.targetContextResolver = targetContextResolver;
            return this;
        }

        public Builder executorServiceBuilder(ExecutorServiceBuilder executorServiceBuilder) {
            BuilderUtils.assertNonNull((Object)executorServiceBuilder, (String)"ExecutorServiceBuilder may not be null");
            this.executorServiceBuilder = executorServiceBuilder;
            return this;
        }

        public Builder requestStreamFactory(Function<UpstreamAwareStreamObserver<CommandProviderInbound>, StreamObserver<CommandProviderOutbound>> requestStreamFactory) {
            BuilderUtils.assertNonNull(requestStreamFactory, (String)"RequestStreamFactory may not be null");
            this.requestStreamFactory = requestStreamFactory;
            return this;
        }

        public Builder instructionAckSource(InstructionAckSource<CommandProviderOutbound> instructionAckSource) {
            BuilderUtils.assertNonNull(instructionAckSource, (String)"InstructionAckSource may not be null");
            this.instructionAckSource = instructionAckSource;
            return this;
        }

        public AxonServerCommandBus build() {
            return new AxonServerCommandBus(this);
        }

        protected CommandSerializer buildSerializer() {
            return new CommandSerializer(this.serializer, this.configuration);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.axonServerConnectionManager, (String)"The AxonServerConnectionManager is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.configuration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.localSegment, (String)"The Local CommandBus is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.serializer, (String)"The Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.routingStrategy, (String)"The RoutingStrategy is a hard requirement and should be provided");
        }
    }
}

