/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.common.AxonThreadFactory;

@FunctionalInterface
public interface ExecutorServiceBuilder
extends BiFunction<AxonServerConfiguration, BlockingQueue<Runnable>, ExecutorService> {
    public static ExecutorServiceBuilder defaultCommandExecutorServiceBuilder() {
        return (configuration, commandProcessQueue) -> new ThreadPoolExecutor(configuration.getCommandThreads(), configuration.getCommandThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)commandProcessQueue, (ThreadFactory)new AxonThreadFactory("CommandProcessor"));
    }

    public static ExecutorServiceBuilder defaultQueryExecutorServiceBuilder() {
        return (configuration, queryProcessQueue) -> new ThreadPoolExecutor(configuration.getQueryThreads(), configuration.getQueryThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queryProcessQueue, (ThreadFactory)new AxonThreadFactory("QueryProcessor"));
    }

    public static ExecutorServiceBuilder defaultQueryResponseExecutorServiceBuilder() {
        return (configuration, queryResponseProcessQueue) -> new ThreadPoolExecutor(configuration.getQueryResponseThreads(), configuration.getQueryResponseThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queryResponseProcessQueue, (ThreadFactory)new AxonThreadFactory("QueryResponse"));
    }
}

