/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.connector.AxonServerConnection;
import io.axoniq.axonserver.connector.AxonServerConnectionFactory;
import io.axoniq.axonserver.connector.impl.ContextConnection;
import io.axoniq.axonserver.connector.impl.ServerAddress;
import io.axoniq.axonserver.grpc.control.NodeInfo;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.axonframework.axonserver.connector.ConnectionManager;
import org.axonframework.axonserver.connector.util.GrpcMessageSizeInterceptor;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.config.TagsConfiguration;
import org.axonframework.lifecycle.Lifecycle;

public class AxonServerConnectionManager
implements Lifecycle,
ConnectionManager {
    private static final int DEFAULT_GRPC_PORT = 8124;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x400000;
    private final Map<String, AxonServerConnection> connections = new ConcurrentHashMap<String, AxonServerConnection>();
    private final AxonServerConnectionFactory connectionFactory;
    private final String defaultContext;
    private final boolean heartbeatEnabled;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;

    protected AxonServerConnectionManager(Builder builder, AxonServerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.defaultContext = builder.axonServerConfiguration.getContext();
        AxonServerConfiguration.HeartbeatConfiguration heartbeatConfig = builder.axonServerConfiguration.getHeartbeat();
        this.heartbeatEnabled = heartbeatConfig.isEnabled();
        this.heartbeatInterval = heartbeatConfig.getInterval();
        this.heartbeatTimeout = heartbeatConfig.getTimeout();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry lifecycle) {
        lifecycle.onStart(0x40000009, this::start);
        lifecycle.onShutdown(-134217728, this::shutdown);
    }

    public void start() {
        if (this.heartbeatEnabled) {
            this.getConnection();
        }
    }

    public AxonServerConnection getConnection() {
        return this.getConnection(this.getDefaultContext());
    }

    public AxonServerConnection getConnection(String context) {
        return this.connections.computeIfAbsent(context, this::createConnection);
    }

    private AxonServerConnection createConnection(String context) {
        AxonServerConnection connection = this.connectionFactory.connect(context);
        if (this.heartbeatEnabled) {
            connection.controlChannel().enableHeartbeat(this.heartbeatInterval, this.heartbeatTimeout, TimeUnit.MILLISECONDS);
        }
        return connection;
    }

    public boolean isConnected(String context) {
        AxonServerConnection channel = this.connections.get(context);
        return channel != null && channel.isConnected();
    }

    public void shutdown() {
        this.connectionFactory.shutdown();
        this.disconnect();
    }

    public void disconnect(String context) {
        AxonServerConnection channel = this.connections.remove(context);
        if (channel != null) {
            channel.disconnect();
        }
    }

    public void disconnect() {
        this.connections.forEach((context, channel) -> channel.disconnect());
        this.connections.clear();
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    @Deprecated
    public Channel getChannel() {
        return ((ContextConnection)this.getConnection(this.defaultContext)).getManagedChannel();
    }

    @Deprecated
    public Channel getChannel(String context) {
        return ((ContextConnection)this.getConnection(context)).getManagedChannel();
    }

    @Override
    public Map<String, Boolean> connections() {
        return this.connections.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AxonServerConnection)entry.getValue()).isConnected()));
    }

    public static class Builder {
        private String routingServers;
        private AxonServerConfiguration axonServerConfiguration;
        private TagsConfiguration tagsConfiguration = new TagsConfiguration();
        private UnaryOperator<ManagedChannelBuilder<?>> channelCustomization;

        public Builder routingServers(String routingServers) {
            BuilderUtils.assertNonEmpty((String)routingServers, (String)"Routing Servers should be a non-empty String of a comma-separated [hostname:grpcPort] entries");
            this.routingServers = routingServers;
            return this;
        }

        public Builder axonServerConfiguration(AxonServerConfiguration axonServerConfiguration) {
            BuilderUtils.assertNonNull((Object)axonServerConfiguration, (String)"AxonServerConfiguration may not be null");
            this.axonServerConfiguration = axonServerConfiguration;
            return this;
        }

        public Builder tagsConfiguration(TagsConfiguration tagsConfiguration) {
            BuilderUtils.assertNonNull((Object)tagsConfiguration, (String)"TagsConfiguration may not be null");
            this.tagsConfiguration = tagsConfiguration;
            return this;
        }

        public Builder channelCustomizer(UnaryOperator<ManagedChannelBuilder<?>> channelCustomization) {
            this.channelCustomization = channelCustomization;
            return this;
        }

        @Deprecated
        public Builder axonFrameworkVersionResolver(Supplier<String> axonFrameworkVersionResolver) {
            return this;
        }

        public AxonServerConnectionManager build() {
            this.validate();
            AxonServerConnectionFactory.Builder builder = AxonServerConnectionFactory.forClient((String)this.axonServerConfiguration.getComponentName(), (String)this.axonServerConfiguration.getClientId());
            this.routingServers = (String)ObjectUtils.getOrDefault((Object)this.routingServers, (Object)this.axonServerConfiguration.getServers());
            List<NodeInfo> nodeInfos = Builder.mapToNodeInfos(this.routingServers);
            if (!nodeInfos.isEmpty()) {
                ServerAddress[] addresses = new ServerAddress[nodeInfos.size()];
                for (int i = 0; i < addresses.length; ++i) {
                    NodeInfo routingServer = nodeInfos.get(i);
                    addresses[i] = new ServerAddress(routingServer.getHostName(), routingServer.getGrpcPort());
                }
                builder.routingServers(addresses);
            }
            if (this.axonServerConfiguration.isSslEnabled()) {
                if (this.axonServerConfiguration.getCertFile() != null) {
                    try {
                        File certificateFile = new File(this.axonServerConfiguration.getCertFile());
                        builder.useTransportSecurity(GrpcSslContexts.forClient().trustManager(certificateFile).build());
                    }
                    catch (SSLException e) {
                        throw new AxonConfigurationException("Exception configuring Transport Security", (Throwable)e);
                    }
                } else {
                    builder.useTransportSecurity();
                }
            }
            builder.connectTimeout(this.axonServerConfiguration.getConnectTimeout(), TimeUnit.MILLISECONDS).reconnectInterval(this.axonServerConfiguration.getReconnectInterval(), TimeUnit.MILLISECONDS).forceReconnectViaRoutingServers(this.axonServerConfiguration.isForceReconnectThroughServers()).threadPoolSize(this.axonServerConfiguration.getConnectionManagementThreadPoolSize()).commandPermits(this.axonServerConfiguration.getCommandFlowControl().getPermits().intValue()).queryPermits(this.axonServerConfiguration.getQueryFlowControl().getPermits().intValue());
            if (this.axonServerConfiguration.getToken() != null) {
                builder.token(this.axonServerConfiguration.getToken());
            }
            this.tagsConfiguration.getTags().forEach((arg_0, arg_1) -> ((AxonServerConnectionFactory.Builder)builder).clientTag(arg_0, arg_1));
            if (this.axonServerConfiguration.getMaxMessageSize() > 0) {
                builder.maxInboundMessageSize(this.axonServerConfiguration.getMaxMessageSize());
            }
            builder.customize(managedChannelBuilder -> managedChannelBuilder.intercept(new ClientInterceptor[]{new GrpcMessageSizeInterceptor(this.axonServerConfiguration.getMaxMessageSize() > 0 ? this.axonServerConfiguration.getMaxMessageSize() : 0x400000, this.axonServerConfiguration.getMaxMessageSizeWarningThreshold())}));
            if (this.axonServerConfiguration.getKeepAliveTime() > 0L) {
                builder.usingKeepAlive(this.axonServerConfiguration.getKeepAliveTime(), this.axonServerConfiguration.getKeepAliveTimeout(), TimeUnit.MILLISECONDS, true);
            }
            if (this.axonServerConfiguration.getProcessorsNotificationRate() > 0) {
                builder.processorInfoUpdateFrequency((long)this.axonServerConfiguration.getProcessorsNotificationRate(), TimeUnit.MILLISECONDS);
            }
            if (this.channelCustomization != null) {
                builder.customize(this.channelCustomization);
            }
            AxonServerConnectionFactory connectionFactory = builder.build();
            return new AxonServerConnectionManager(this, connectionFactory);
        }

        private static List<NodeInfo> mapToNodeInfos(String servers) {
            String[] serverArray = servers.split(",");
            return Arrays.stream(serverArray).map(server -> {
                String[] s = server.trim().split(":");
                return s.length > 1 ? NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(Integer.parseInt(s[1])).build() : NodeInfo.newBuilder().setHostName(s[0]).setGrpcPort(8124).build();
            }).collect(Collectors.toList());
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.axonServerConfiguration, (String)"The AxonServerConfiguration is a hard requirement and should be provided");
        }
    }
}

