/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector;

import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.axonframework.axonserver.connector.AxonServerException;
import org.axonframework.axonserver.connector.command.AxonServerCommandDispatchException;
import org.axonframework.axonserver.connector.command.AxonServerRemoteCommandHandlingException;
import org.axonframework.axonserver.connector.query.AxonServerQueryDispatchException;
import org.axonframework.axonserver.connector.query.AxonServerRemoteQueryHandlingException;
import org.axonframework.axonserver.connector.util.ExceptionSerializer;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.AxonException;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.messaging.EventPublicationFailedException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.queryhandling.NoHandlerForQueryException;
import org.axonframework.queryhandling.QueryExecutionException;

public enum ErrorCode {
    AUTHENTICATION_TOKEN_MISSING("AXONIQ-1000", AxonServerException::new),
    AUTHENTICATION_INVALID_TOKEN("AXONIQ-1001", AxonServerException::new),
    INVALID_EVENT_SEQUENCE("AXONIQ-2000", (code, error) -> new ConcurrencyException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    NO_EVENT_STORE_MASTER_AVAILABLE("AXONIQ-2100", (code, error) -> new EventPublicationFailedException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    EVENT_PAYLOAD_TOO_LARGE("AXONIQ-2001", (code, error) -> new EventPublicationFailedException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    CONNECTION_FAILED("AXONIQ-3001", AxonServerException::new),
    GRPC_MESSAGE_TOO_LARGE("AXONIQ-3002", AxonServerException::new),
    NO_HANDLER_FOR_COMMAND("AXONIQ-4000", (code, error) -> new NoHandlerForCommandException(error.getMessage())),
    COMMAND_EXECUTION_ERROR("AXONIQ-4002", (code, error) -> new CommandExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerRemoteCommandHandlingException((String)code, (ErrorMessage)error)))),
    COMMAND_DISPATCH_ERROR("AXONIQ-4003", AxonServerCommandDispatchException::new),
    NO_HANDLER_FOR_QUERY("AXONIQ-5000", (code, error) -> new NoHandlerForQueryException(error.getMessage())),
    QUERY_EXECUTION_ERROR("AXONIQ-5001", (code, error) -> new QueryExecutionException(error.getMessage(), (Throwable)((Object)new AxonServerRemoteQueryHandlingException((String)code, (ErrorMessage)error)))),
    QUERY_DISPATCH_ERROR("AXONIQ-5002", AxonServerQueryDispatchException::new),
    DATAFILE_READ_ERROR("AXONIQ-9000", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    INDEX_READ_ERROR("AXONIQ-9001", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    DATAFILE_WRITE_ERROR("AXONIQ-9100", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    INDEX_WRITE_ERROR("AXONIQ-9101", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    DIRECTORY_CREATION_FAILED("AXONIQ-9102", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    VALIDATION_FAILED("AXONIQ-9200", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    TRANSACTION_ROLLED_BACK("AXONIQ-9900", (code, error) -> new EventStoreException(error.getMessage(), (Throwable)((Object)new AxonServerException((String)code, (ErrorMessage)error)))),
    OTHER("AXONIQ-0001", AxonServerException::new);

    private final String errorCode;
    private final BiFunction<String, ErrorMessage, ? extends AxonException> exceptionBuilder;

    private ErrorCode(String errorCode, BiFunction<String, ErrorMessage, ? extends AxonException> exceptionBuilder) {
        this.errorCode = errorCode;
        this.exceptionBuilder = exceptionBuilder;
    }

    public static ErrorCode getFromCode(String code) {
        return Arrays.stream(ErrorCode.values()).filter(value -> value.errorCode.equals(code)).findFirst().orElse(OTHER);
    }

    public String errorCode() {
        return this.errorCode;
    }

    public AxonException convert(ErrorMessage errorMessage) {
        return this.exceptionBuilder.apply(this.errorCode, errorMessage);
    }

    public AxonException convert(Throwable throwable) {
        return this.convert(null, throwable);
    }

    public AxonException convert(String source, Throwable throwable) {
        return this.convert(ExceptionSerializer.serialize(source, throwable));
    }
}

