/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.util;

import io.axoniq.axonserver.grpc.FlowControl;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.axonframework.axonserver.connector.AxonServerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowControllingStreamObserver<T>
implements StreamObserver<T> {
    private final StreamObserver<T> wrappedStreamObserver;
    private static final Logger logger = LoggerFactory.getLogger(FlowControllingStreamObserver.class);
    private final AtomicLong remainingPermits;
    private final long newPermits;
    private final AxonServerConfiguration configuration;
    private final T newPermitsRequest;
    private final Predicate<T> isConfirmationMessage;
    private final Function<FlowControl, T> requestWrapper;

    public FlowControllingStreamObserver(StreamObserver<T> wrappedStreamObserver, AxonServerConfiguration configuration, Function<FlowControl, T> requestWrapper, Predicate<T> isConfirmationMessage) {
        this.wrappedStreamObserver = wrappedStreamObserver;
        this.configuration = configuration;
        this.remainingPermits = new AtomicLong(configuration.getInitialNrOfPermits() - configuration.getNewPermitsThreshold());
        this.newPermits = configuration.getNrOfNewPermits().intValue();
        this.newPermitsRequest = requestWrapper.apply(this.createRequest(this.newPermits));
        this.isConfirmationMessage = isConfirmationMessage;
        this.requestWrapper = requestWrapper;
    }

    public FlowControllingStreamObserver<T> sendInitialPermits() {
        this.wrappedStreamObserver.onNext(this.requestWrapper.apply(this.createRequest(this.configuration.getInitialNrOfPermits().intValue())));
        return this;
    }

    private FlowControl createRequest(long initialNrOfPermits) {
        return FlowControl.newBuilder().setClientId(this.configuration.getClientId()).setPermits(initialNrOfPermits).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(T t) {
        StreamObserver<T> streamObserver = this.wrappedStreamObserver;
        synchronized (streamObserver) {
            this.wrappedStreamObserver.onNext(t);
        }
        logger.debug("Sending response to AxonServer platform, remaining permits: {}", (Object)this.remainingPermits.get());
        if (this.isConfirmationMessage.test(t)) {
            this.markConsumed(1);
        }
    }

    public void onError(Throwable throwable) {
        this.wrappedStreamObserver.onError(throwable);
    }

    public void onCompleted() {
        logger.info("Observer stopped");
        try {
            this.wrappedStreamObserver.onCompleted();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markConsumed(Integer consumed) {
        if (this.remainingPermits.updateAndGet(old -> old - (long)consumed.intValue()) == 0L) {
            this.remainingPermits.addAndGet(this.newPermits);
            StreamObserver<T> streamObserver = this.wrappedStreamObserver;
            synchronized (streamObserver) {
                this.wrappedStreamObserver.onNext(this.newPermitsRequest);
            }
            logger.info("Granting new permits: {}", this.newPermitsRequest);
        }
    }
}

