/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotation;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityMetamodel;
import org.axonframework.modelling.entity.annotation.AnnotatedEntityModelRoutingKeyMatcher;
import org.axonframework.modelling.entity.child.ChildAmbiguityException;
import org.axonframework.modelling.entity.child.CommandTargetResolver;

public class RoutingKeyCommandTargetResolver<E>
implements CommandTargetResolver<E> {
    private final AnnotatedEntityModelRoutingKeyMatcher<E> routingKeyEntityMatcher;

    public RoutingKeyCommandTargetResolver(@Nonnull AnnotatedEntityMetamodel<E> metamodel, @Nonnull String entityRoutingProperty, @Nonnull String messageRoutingProperty) {
        this.routingKeyEntityMatcher = new AnnotatedEntityModelRoutingKeyMatcher<E>(metamodel, entityRoutingProperty, messageRoutingProperty);
    }

    @Override
    public E getTargetChildEntity(@Nonnull List<E> childEntities, @Nonnull CommandMessage message, @Nonnull ProcessingContext context) {
        List<Object> matchingCandidates = childEntities.stream().filter(entity -> this.routingKeyEntityMatcher.matches(entity, (Message)message)).toList();
        if (matchingCandidates.size() > 1) {
            throw new ChildAmbiguityException("Multiple child entities found for command of type [%s], while only one was expected. Matching candidates are: [%s]".formatted(message.type(), matchingCandidates));
        }
        if (matchingCandidates.size() == 1) {
            return (E)matchingCandidates.getFirst();
        }
        return null;
    }
}

