/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.DuplicateCommandHandlerSubscriptionException;
import org.axonframework.messaging.commandhandling.NoHandlerForCommandException;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.modelling.EntityEvolver;
import org.axonframework.modelling.entity.ChildEntityNotFoundException;
import org.axonframework.modelling.entity.EntityAlreadyExistsForCreationalCommandHandlerException;
import org.axonframework.modelling.entity.EntityCommandHandler;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.entity.EntityMetamodelBuilder;
import org.axonframework.modelling.entity.EntityMissingForInstanceCommandHandlerException;
import org.axonframework.modelling.entity.child.ChildAmbiguityException;
import org.axonframework.modelling.entity.child.EntityChildMetamodel;

public class ConcreteEntityMetamodel<E>
implements DescribableComponent,
EntityMetamodel<E> {
    private final Class<E> entityType;
    private final List<EntityChildMetamodel<?, E>> children = new LinkedList();
    private final Map<QualifiedName, EntityCommandHandler<E>> instanceCommandHandlers = new HashMap<QualifiedName, EntityCommandHandler<E>>();
    private final Map<QualifiedName, CommandHandler> creationalCommandHandlers = new HashMap<QualifiedName, CommandHandler>();
    private final EntityEvolver<E> entityEvolver;
    private final Set<QualifiedName> supportedCommandNames = new HashSet<QualifiedName>();
    private final Set<QualifiedName> supportedInstanceCommandNames = new HashSet<QualifiedName>();
    private final Set<QualifiedName> supportedCreationalCommandNames = new HashSet<QualifiedName>();

    private ConcreteEntityMetamodel(@Nonnull Class<E> entityType, @Nonnull Map<QualifiedName, EntityCommandHandler<E>> instanceCommandHandlers, @Nonnull Map<QualifiedName, CommandHandler> creationalCommandHandlers, @Nonnull List<EntityChildMetamodel<?, E>> children, @Nullable EntityEvolver<E> entityEvolver) {
        this.entityType = Objects.requireNonNull(entityType, "The entityType may not be null.");
        this.entityEvolver = entityEvolver;
        this.instanceCommandHandlers.putAll(Objects.requireNonNull(instanceCommandHandlers, "The instanceCommandHandlers may not be null."));
        this.creationalCommandHandlers.putAll(Objects.requireNonNull(creationalCommandHandlers, "The creationalCommandHandlers may not be null."));
        this.children.addAll((Collection)Objects.requireNonNull(children, "The children may not be null."));
        this.supportedCreationalCommandNames.addAll(creationalCommandHandlers.keySet());
        this.supportedInstanceCommandNames.addAll(instanceCommandHandlers.keySet());
        children.forEach(child -> this.supportedInstanceCommandNames.addAll(child.supportedCommands()));
        this.supportedCommandNames.addAll(this.supportedCreationalCommandNames);
        this.supportedCommandNames.addAll(this.supportedInstanceCommandNames);
    }

    @Nonnull
    public static <E> EntityMetamodelBuilder<E> forEntityClass(@Nonnull Class<E> entityType) {
        Objects.requireNonNull(entityType, "The entityType may not be null.");
        return new Builder<E>(entityType);
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCommands() {
        return Collections.unmodifiableSet(this.supportedCommandNames);
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedCreationalCommands() {
        return Collections.unmodifiableSet(this.supportedCreationalCommandNames);
    }

    @Override
    @Nonnull
    public Set<QualifiedName> supportedInstanceCommands() {
        return Collections.unmodifiableSet(this.supportedInstanceCommandNames);
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleCreate(@Nonnull CommandMessage message, @Nonnull ProcessingContext context) {
        if (this.isInstanceCommand(message) && !this.isCreationalCommand(message)) {
            return MessageStream.failed((Throwable)new EntityMissingForInstanceCommandHandlerException(message));
        }
        try {
            CommandHandler commandHandler = this.creationalCommandHandlers.get(message.type().qualifiedName());
            if (commandHandler != null) {
                return commandHandler.handle(message, context);
            }
        }
        catch (Exception e) {
            return MessageStream.failed((Throwable)e);
        }
        return MessageStream.failed((Throwable)new NoHandlerForCommandException(message, this.entityType));
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage> handleInstance(@Nonnull CommandMessage message, @Nonnull E entity, @Nonnull ProcessingContext context) {
        if (this.isCreationalCommand(message) && !this.isInstanceCommand(message)) {
            return MessageStream.failed((Throwable)new EntityAlreadyExistsForCreationalCommandHandlerException(message, entity));
        }
        try {
            List<EntityChildMetamodel<?, E>> childrenWithCommandHandlers = this.children.stream().filter(childEntity -> childEntity.supportedCommands().contains(message.type().qualifiedName())).toList();
            if (!childrenWithCommandHandlers.isEmpty()) {
                return this.handleForChildren(childrenWithCommandHandlers, message, entity, context);
            }
            EntityCommandHandler<E> commandHandler = this.instanceCommandHandlers.get(message.type().qualifiedName());
            if (commandHandler != null) {
                return commandHandler.handle(message, entity, context);
            }
        }
        catch (Exception e) {
            return MessageStream.failed((Throwable)e);
        }
        return MessageStream.failed((Throwable)new NoHandlerForCommandException(message, this.entityType));
    }

    @Override
    @Nullable
    public E evolve(@Nonnull E entity, @Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        E currentEntity = entity;
        for (EntityChildMetamodel<?, E> child : this.children) {
            currentEntity = child.evolve(currentEntity, event, context);
        }
        if (this.entityEvolver == null) {
            return currentEntity;
        }
        return this.entityEvolver.evolve(currentEntity, event, context);
    }

    private MessageStream.Single<CommandResultMessage> handleForChildren(List<EntityChildMetamodel<?, E>> childrenWithCommandHandler, CommandMessage message, E entity, ProcessingContext context) {
        if (childrenWithCommandHandler.size() == 1) {
            return childrenWithCommandHandler.getFirst().handle(message, entity, context);
        }
        List<EntityChildMetamodel> matchingChildren = childrenWithCommandHandler.stream().filter(childEntity -> childEntity.canHandle(message, entity, context)).toList();
        if (matchingChildren.size() == 1) {
            return matchingChildren.getFirst().handle(message, entity, context);
        }
        if (matchingChildren.size() > 1) {
            return MessageStream.failed((Throwable)new ChildAmbiguityException("Multiple matching child entity members found for command of type [%s]. Matching candidates are: [%s]".formatted(message, matchingChildren)));
        }
        return MessageStream.failed((Throwable)new ChildEntityNotFoundException(message, entity));
    }

    @Override
    @Nonnull
    public Class<E> entityType() {
        return this.entityType;
    }

    private boolean isCreationalCommand(CommandMessage message) {
        return this.creationalCommandHandlers.containsKey(message.type().qualifiedName());
    }

    private boolean isInstanceCommand(CommandMessage message) {
        return this.instanceCommandHandlers.containsKey(message.type().qualifiedName());
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("entityType", this.entityType);
        descriptor.describeProperty("commandHandlers", this.instanceCommandHandlers);
        descriptor.describeProperty("supportedCommandNames", this.supportedCommandNames);
        descriptor.describeProperty("supportedInstanceCommandNames", this.supportedInstanceCommandNames);
        descriptor.describeProperty("supportedCreationalCommandNames", this.supportedCreationalCommandNames);
        descriptor.describeProperty("entityEvolver", this.entityEvolver);
        descriptor.describeProperty("children", this.children);
    }

    public String toString() {
        return "ConcreteEntityMessageMetamodel{entityType=" + this.entityType.getName() + "}";
    }

    private static class Builder<E>
    implements EntityMetamodelBuilder<E> {
        private final Class<E> entityType;
        private final Map<QualifiedName, EntityCommandHandler<E>> commandHandlers = new HashMap<QualifiedName, EntityCommandHandler<E>>();
        private final Map<QualifiedName, CommandHandler> creationalCommandHandlers = new HashMap<QualifiedName, CommandHandler>();
        private final List<EntityChildMetamodel<?, E>> children = new ArrayList();
        private EntityEvolver<E> entityEvolver;

        private Builder(Class<E> entityType) {
            this.entityType = entityType;
        }

        @Override
        @Nonnull
        public Builder<E> instanceCommandHandler(@Nonnull QualifiedName qualifiedName, @Nonnull EntityCommandHandler<E> messageHandler) {
            Objects.requireNonNull(qualifiedName, "The qualifiedName may not be null.");
            Objects.requireNonNull(messageHandler, "The messageHandler may not be null.");
            if (this.commandHandlers.containsKey(qualifiedName)) {
                throw new DuplicateCommandHandlerSubscriptionException("Duplicate subscription for command [%s] detected. Registration of handler [%s] conflicts with previously registered handler [%s].".formatted(qualifiedName, this.commandHandlers.get(qualifiedName), messageHandler));
            }
            this.commandHandlers.put(qualifiedName, messageHandler);
            return this;
        }

        @Override
        @Nonnull
        public EntityMetamodelBuilder<E> creationalCommandHandler(@Nonnull QualifiedName qualifiedName, @Nonnull CommandHandler messageHandler) {
            Objects.requireNonNull(qualifiedName, "The qualifiedName may not be null.");
            Objects.requireNonNull(messageHandler, "The messageHandler may not be null.");
            if (this.creationalCommandHandlers.containsKey(qualifiedName)) {
                throw new DuplicateCommandHandlerSubscriptionException("Duplicate subscription for command [%s] detected. Registration of handler [%s] conflicts with previously registered handler [%s].".formatted(qualifiedName, this.creationalCommandHandlers.get(qualifiedName), messageHandler));
            }
            this.creationalCommandHandlers.put(qualifiedName, messageHandler);
            return this;
        }

        @Override
        @Nonnull
        public Builder<E> addChild(@Nonnull EntityChildMetamodel<?, E> child) {
            Objects.requireNonNull(child, "The child may not be null.");
            if (!child.entityMetamodel().supportedCreationalCommands().isEmpty()) {
                throw new IllegalArgumentException("Child entities should not have any creational command handlers.");
            }
            this.children.add(child);
            return this;
        }

        @Override
        @Nonnull
        public EntityMetamodelBuilder<E> entityEvolver(@Nullable EntityEvolver<E> entityEvolver) {
            this.entityEvolver = entityEvolver;
            return this;
        }

        @Override
        @Nonnull
        public EntityMetamodel<E> build() {
            return new ConcreteEntityMetamodel<E>(this.entityType, this.commandHandlers, this.creationalCommandHandlers, this.children, this.entityEvolver);
        }
    }
}

