/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.modelling.MissingRepositoryException;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;

public class HierarchicalStateManager
implements StateManager {
    private final StateManager parent;
    private final StateManager child;

    private HierarchicalStateManager(@Nonnull StateManager parent, @Nonnull StateManager child) {
        this.parent = Objects.requireNonNull(parent, "Parent StateManager may not be null");
        this.child = Objects.requireNonNull(child, "Child StateManager may not be null");
    }

    public static HierarchicalStateManager create(@Nonnull StateManager parent, @Nonnull StateManager child) {
        return new HierarchicalStateManager(parent, child);
    }

    public <I, T> StateManager register(@Nonnull Repository<I, T> repository) {
        Objects.requireNonNull(repository, "The repository must not be null.");
        this.child.register(repository);
        return this;
    }

    public <I, T> CompletableFuture<ManagedEntity<I, T>> loadManagedEntity(@Nonnull Class<T> type, @Nonnull I id, @Nonnull ProcessingContext context) {
        Class<?> idClass = id.getClass();
        Repository<?, T> repository = this.repository(type, (Class<I>)idClass);
        if (repository != null) {
            return repository.loadOrCreate(id, context);
        }
        throw new MissingRepositoryException(id.getClass(), type);
    }

    @Override
    public Set<Class<?>> registeredEntities() {
        HashSet classes = new HashSet();
        classes.addAll(this.parent.registeredEntities());
        classes.addAll(this.child.registeredEntities());
        return classes;
    }

    @Override
    public Set<Class<?>> registeredIdsFor(@Nonnull Class<?> entityType) {
        HashSet classes = new HashSet();
        classes.addAll(this.parent.registeredIdsFor(entityType));
        classes.addAll(this.child.registeredIdsFor(entityType));
        return classes;
    }

    public <I, T> Repository<I, T> repository(@Nonnull Class<T> entityType, @Nonnull Class<I> idType) {
        Repository<I, T> childRepository = this.child.repository(entityType, idType);
        if (childRepository != null) {
            return childRepository;
        }
        return this.parent.repository(entityType, idType);
    }

    public StateManager getParent() {
        return this.parent;
    }

    public StateManager getChild() {
        return this.child;
    }
}

