/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.TypeReference;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandlingComponent;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.configuration.EntityMetamodelConfigurationBuilder;
import org.axonframework.modelling.configuration.StateBasedEntityModule;
import org.axonframework.modelling.entity.EntityCommandHandlingComponent;
import org.axonframework.modelling.entity.EntityMetamodel;
import org.axonframework.modelling.repository.Repository;
import org.axonframework.modelling.repository.SimpleRepository;
import org.axonframework.modelling.repository.SimpleRepositoryEntityLoader;
import org.axonframework.modelling.repository.SimpleRepositoryEntityPersister;

class SimpleStateBasedEntityModule<ID, E>
extends BaseModule<SimpleStateBasedEntityModule<ID, E>>
implements StateBasedEntityModule<ID, E>,
StateBasedEntityModule.RepositoryPhase<ID, E>,
StateBasedEntityModule.PersisterPhase<ID, E>,
StateBasedEntityModule.MessagingMetamodelPhase<ID, E>,
StateBasedEntityModule.EntityIdResolverPhase<ID, E> {
    private final Class<ID> idType;
    private final Class<E> entityType;
    private ComponentBuilder<SimpleRepositoryEntityLoader<ID, E>> loader;
    private ComponentBuilder<SimpleRepositoryEntityPersister<ID, E>> persister;
    private ComponentBuilder<Repository<ID, E>> repository;
    private ComponentBuilder<EntityMetamodel<E>> entityModel;
    private ComponentBuilder<EntityIdResolver<ID>> entityIdResolver;

    SimpleStateBasedEntityModule(@Nonnull Class<ID> idType, @Nonnull Class<E> entityType) {
        super("SimpleStateBasedEntityModule<%s, %s>".formatted(idType.getName(), entityType.getName()));
        this.idType = Objects.requireNonNull(idType, "The identifier type cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "The entity type cannot be null.");
    }

    @Override
    public StateBasedEntityModule.MessagingMetamodelPhase<ID, E> persister(@Nonnull ComponentBuilder<SimpleRepositoryEntityPersister<ID, E>> persister) {
        this.persister = Objects.requireNonNull(persister, "The repository persister builder cannot be null.");
        return this;
    }

    @Override
    public StateBasedEntityModule.PersisterPhase<ID, E> loader(@Nonnull ComponentBuilder<SimpleRepositoryEntityLoader<ID, E>> loader) {
        this.loader = Objects.requireNonNull(loader, "The repository loader builder cannot be null.");
        return this;
    }

    @Override
    public StateBasedEntityModule.MessagingMetamodelPhase<ID, E> repository(@Nonnull ComponentBuilder<Repository<ID, E>> repository) {
        this.repository = Objects.requireNonNull(repository, "The repository builder cannot be null.");
        return this;
    }

    @Override
    public StateBasedEntityModule.EntityIdResolverPhase<ID, E> messagingModel(@Nonnull EntityMetamodelConfigurationBuilder<E> metamodelFactory) {
        Objects.requireNonNull(metamodelFactory, "The metamodelFactory cannot be null.");
        this.entityModel = c -> metamodelFactory.build(c, EntityMetamodel.forEntityType(this.entityType));
        return this;
    }

    @Override
    public StateBasedEntityModule<ID, E> entityIdResolver(@Nonnull ComponentBuilder<EntityIdResolver<ID>> entityIdResolver) {
        this.entityIdResolver = Objects.requireNonNull(entityIdResolver, "The EntityIdResolver builder cannot be null.");
        return this;
    }

    @Override
    public String entityName() {
        return this.entityType.getSimpleName() + "#" + this.idType.getSimpleName();
    }

    @Override
    public Class<ID> idType() {
        return this.idType;
    }

    @Override
    public Class<E> entityType() {
        return this.entityType;
    }

    public Configuration build(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        this.validate();
        this.registerRepository();
        this.registerCommandHandlingComponentIfModelIsPresent();
        return super.build(parent, lifecycleRegistry);
    }

    private void validate() {
        if (this.repository == null) {
            Objects.requireNonNull(this.loader, "The repository loader builder must be provided if no repository is given.");
            Objects.requireNonNull(this.persister, "The repository persister builder must be provided if no repository is given.");
        }
        if (this.entityModel != null) {
            Objects.requireNonNull(this.entityIdResolver, "The entity ID resolver builder must be provided if an EntityModel is given.");
        }
    }

    private void registerRepository() {
        this.componentRegistry(cr -> cr.registerComponent(ComponentDefinition.ofTypeAndName((TypeReference)new TypeReference<Repository<ID, E>>(this){}, (String)this.entityName()).withBuilder(c -> {
            if (this.repository != null) {
                return (Repository)this.repository.build(c);
            }
            return new SimpleRepository<ID, E>(this.idType, this.entityType, (SimpleRepositoryEntityLoader)this.loader.build(c), (SimpleRepositoryEntityPersister)this.persister.build(c));
        }).onStart(0, (config, component) -> {
            ((StateManager)config.getComponent(StateManager.class)).register(component);
            return FutureUtils.emptyCompletedFuture();
        })));
    }

    private void registerCommandHandlingComponentIfModelIsPresent() {
        if (this.entityModel == null) {
            return;
        }
        this.componentRegistry(cr -> cr.registerComponent(ComponentDefinition.ofTypeAndName((TypeReference)new TypeReference<EntityMetamodel<E>>(this){}, (String)this.entityName()).withBuilder(this.entityModel)));
        this.componentRegistry(cr -> cr.registerComponent(ComponentDefinition.ofTypeAndName((TypeReference)new TypeReference<EntityIdResolver<ID>>(this){}, (String)this.entityName()).withBuilder(this.entityIdResolver)));
        this.componentRegistry(cr -> cr.registerComponent(ComponentDefinition.ofTypeAndName(CommandHandlingComponent.class, (String)this.entityName()).withBuilder(c -> new EntityCommandHandlingComponent((Repository)c.getComponent(Repository.class, this.entityName()), (EntityMetamodel)c.getComponent(EntityMetamodel.class, this.entityName()), (EntityIdResolver)c.getComponent(EntityIdResolver.class, this.entityName()))).onStart(0, (config, component) -> {
            ((CommandBus)config.getComponent(CommandBus.class)).subscribe(component);
            return FutureUtils.emptyCompletedFuture();
        })));
    }

    public StateBasedEntityModule<ID, E> build() {
        return this;
    }
}

