/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotations;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Optional;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.modelling.entity.annotations.AnnotatedEntityMetamodel;
import org.axonframework.modelling.entity.annotations.CommandTargetResolverDefinition;
import org.axonframework.modelling.entity.annotations.RoutingKeyCommandTargetResolver;
import org.axonframework.modelling.entity.annotations.RoutingKeyUtils;
import org.axonframework.modelling.entity.child.CommandTargetResolver;

public class RoutingKeyCommandTargetResolverDefinition
implements CommandTargetResolverDefinition {
    @Override
    @Nonnull
    public <E> CommandTargetResolver<E> createCommandTargetResolver(@Nonnull AnnotatedEntityMetamodel<E> metamodel, @Nonnull Member member) {
        Optional<String> messageRoutingField = RoutingKeyUtils.getMessageRoutingKey((AnnotatedElement)((Object)member));
        Optional<String> entityRoutingField = RoutingKeyUtils.getEntityRoutingKey(metamodel.entityType());
        if (messageRoutingField.isPresent() && entityRoutingField.isPresent()) {
            return new RoutingKeyCommandTargetResolver<E>(metamodel, entityRoutingField.get(), messageRoutingField.get());
        }
        if (entityRoutingField.isPresent()) {
            return new RoutingKeyCommandTargetResolver<E>(metamodel, entityRoutingField.get(), entityRoutingField.get());
        }
        Class memberValueType = ReflectionUtils.getMemberValueType((Member)member);
        if (Iterable.class.isAssignableFrom(memberValueType)) {
            throw new AxonConfigurationException(String.format("Member [%s] of type [%s] is a collection type, but the child does not define a @RoutingKey. Please implement a custom CommandTargetResolver for this collection type or add @RoutingKey to a field or method to identify the child entity correctly.", member, memberValueType));
        }
        return CommandTargetResolver.MATCH_ANY();
    }
}

