/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.entity.annotations;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityIdResolutionException;
import org.axonframework.modelling.EntityIdResolver;
import org.axonframework.modelling.entity.annotations.AnnotatedEntityMetamodel;
import org.axonframework.serialization.Converter;

public class AnnotatedEntityIdResolver<ID>
implements EntityIdResolver<ID>,
DescribableComponent {
    private final AnnotatedEntityMetamodel<?> metamodel;
    private final MessageConverter converter;
    private final EntityIdResolver<ID> delegate;
    private final Class<ID> idType;

    public AnnotatedEntityIdResolver(@Nonnull AnnotatedEntityMetamodel<?> metamodel, @Nonnull Class<ID> idType, @Nonnull MessageConverter converter, @Nonnull EntityIdResolver<ID> delegate) {
        this.idType = Objects.requireNonNull(idType, "The idType should not be null.");
        this.metamodel = Objects.requireNonNull(metamodel, "The metamodel should not be null,");
        this.converter = Objects.requireNonNull(converter, "The converter should not be null.");
        this.delegate = Objects.requireNonNull(delegate, "The delegate should not be null.");
    }

    @Override
    @Nonnull
    public ID resolve(@Nonnull Message message, @Nonnull ProcessingContext context) throws EntityIdResolutionException {
        Class<?> expectedRepresentation = this.metamodel.getExpectedRepresentation(message.type().qualifiedName());
        if (expectedRepresentation != null) {
            return this.delegate.resolve(message.withConvertedPayload(expectedRepresentation, (Converter)this.converter), context);
        }
        throw new AxonConfigurationException("No expected representation found for message type [" + String.valueOf(message.type().qualifiedName()) + "]");
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("converter", (Object)this.converter);
        descriptor.describeProperty("idType", this.idType);
        descriptor.describeProperty("metaModel", this.metamodel);
    }
}

