/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jpa;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

@Entity
public class SagaEntry<T> {
    @Id
    protected String sagaId;
    @Basic
    protected String sagaType;
    @Basic
    protected String revision;
    @Lob
    @Column(length=10000)
    protected byte[] serializedSaga;

    public SagaEntry(T saga, String sagaIdentifier, Serializer serializer) {
        this.sagaId = sagaIdentifier;
        SerializedObject serialized = serializer.serialize(saga, byte[].class);
        this.serializedSaga = (byte[])serialized.getData();
        this.sagaType = serialized.getType().getName();
        this.revision = serialized.getType().getRevision();
    }

    protected SagaEntry() {
    }

    public byte[] getSerializedSaga() {
        return this.serializedSaga;
    }

    public String getSagaId() {
        return this.sagaId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getSagaType() {
        return this.sagaType;
    }
}

