/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Executable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.modelling.saga.AssociationResolver;

public class PayloadAssociationResolver
implements AssociationResolver {
    private Map<String, Property<?>> propertyMap = new ConcurrentHashMap();

    @Override
    public <T> void validate(@Nonnull String associationPropertyName, @Nonnull MessageHandlingMember<T> handler) {
        this.getProperty(associationPropertyName, handler);
    }

    @Override
    public <T> Object resolve(@Nonnull String associationPropertyName, @Nonnull EventMessage message, @Nonnull MessageHandlingMember<T> handler) {
        return this.getProperty(associationPropertyName, handler).getValue(message.payload());
    }

    private <T> Property getProperty(String associationPropertyName, MessageHandlingMember<T> handler) {
        return this.propertyMap.computeIfAbsent(handler.payloadType().getCanonicalName() + associationPropertyName, k -> this.createProperty(associationPropertyName, handler));
    }

    private <T> Property createProperty(String associationPropertyName, MessageHandlingMember<T> handler) {
        if (associationPropertyName.isEmpty()) {
            throw new AxonConfigurationException(String.format("SagaEventHandler %s does not define an association property", this.getHandlerName(handler)));
        }
        Property associationProperty = PropertyAccessStrategy.getProperty((Class)handler.payloadType(), (String)associationPropertyName);
        if (associationProperty == null) {
            throw new AxonConfigurationException(String.format("SagaEventHandler %s defines a property %s that is not defined on the Event it declares to handle (%s)", this.getHandlerName(handler), associationPropertyName, handler.payloadType().getName()));
        }
        return associationProperty;
    }

    private String getHandlerName(MessageHandlingMember<?> handler) {
        return handler.unwrap(Executable.class).map(Executable::toGenericString).orElse("unknown");
    }
}

