/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.modelling.saga.AssociationResolver;
import org.axonframework.modelling.saga.SagaCreationPolicy;
import org.axonframework.modelling.saga.SagaMethodMessageHandlingMember;

public class SagaMethodMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    private final Map<Class<? extends AssociationResolver>, AssociationResolver> associationResolverMap = new ConcurrentHashMap<Class<? extends AssociationResolver>, AssociationResolver>();

    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        Optional keyName = original.attribute("SagaEventHandler.keyName");
        Optional associationProperty = original.attribute("SagaEventHandler.associationProperty");
        Optional associationResolver = original.attribute("SagaEventHandler.associationResolver");
        if (keyName.isPresent() && associationProperty.isPresent() && associationResolver.isPresent()) {
            Optional optionalForceNew = original.attribute("StartSaga.forceNew");
            SagaCreationPolicy creationPolicy = optionalForceNew.map(forceNew -> forceNew != false ? SagaCreationPolicy.ALWAYS : SagaCreationPolicy.IF_NONE_FOUND).orElse(SagaCreationPolicy.NONE);
            return this.doWrapHandler(original, creationPolicy, (String)keyName.get(), (String)associationProperty.get(), (Class)associationResolver.get());
        }
        return original;
    }

    private <T> MessageHandlingMember<T> doWrapHandler(MessageHandlingMember<T> original, SagaCreationPolicy creationPolicy, String associationKeyName, String associationPropertyName, Class<? extends AssociationResolver> associationResolverClass) {
        String associationKey = this.associationKey(associationKeyName, associationPropertyName);
        AssociationResolver associationResolver = this.findAssociationResolver(associationResolverClass);
        associationResolver.validate(associationPropertyName, original);
        return new SagaMethodMessageHandlingMember<T>(original, creationPolicy, associationKey, associationPropertyName, associationResolver);
    }

    private String associationKey(String keyName, String associationProperty) {
        return "".equals(keyName) ? associationProperty : keyName;
    }

    private AssociationResolver findAssociationResolver(Class<? extends AssociationResolver> associationResolverClass) {
        return this.associationResolverMap.computeIfAbsent(associationResolverClass, this::instantiateAssociationResolver);
    }

    private AssociationResolver instantiateAssociationResolver(Class<? extends AssociationResolver> associationResolverClass) {
        try {
            return associationResolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AxonConfigurationException(String.format("`AssociationResolver` %s must define an accessible no-args constructor.", associationResolverClass.getName()), (Throwable)e);
        }
    }
}

