/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.AssociationValues;
import org.axonframework.modelling.saga.AssociationValuesImpl;
import org.axonframework.modelling.saga.Saga;
import org.axonframework.modelling.saga.SagaExecutionException;
import org.axonframework.modelling.saga.SagaLifecycle;
import org.axonframework.modelling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.modelling.saga.metamodel.SagaModel;

public class AnnotatedSaga<T>
extends SagaLifecycle
implements Saga<T> {
    private final SagaModel<T> metaModel;
    private final MessageHandlerInterceptorMemberChain<T> chainedInterceptor;
    private final AssociationValues associationValues;
    private final String sagaId;
    private final T sagaInstance;
    private volatile boolean isActive = true;

    public AnnotatedSaga(String sagaId, Set<AssociationValue> associationValues, T annotatedSaga, SagaModel<T> metaModel, MessageHandlerInterceptorMemberChain<T> chainedInterceptor) {
        Assert.notNull(annotatedSaga, () -> "SagaInstance may not be null");
        this.sagaId = sagaId;
        this.associationValues = new AssociationValuesImpl(associationValues);
        this.sagaInstance = annotatedSaga;
        this.metaModel = metaModel;
        this.chainedInterceptor = chainedInterceptor;
    }

    @Override
    public String getSagaIdentifier() {
        return this.sagaId;
    }

    @Override
    public AssociationValues getAssociationValues() {
        return this.associationValues;
    }

    @Override
    public <R> R invoke(Function<T, R> invocation) {
        try {
            return (R)this.executeWithResult(() -> invocation.apply(this.sagaInstance));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SagaExecutionException("Exception while invoking a Saga", e);
        }
    }

    @Override
    public void execute(Consumer<T> invocation) {
        super.execute(() -> invocation.accept(this.sagaInstance));
    }

    public final boolean canHandle(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        return this.isActive && this.metaModel.findHandlerMethods(event, context).stream().anyMatch(h -> h.unwrap(SagaMethodMessageHandlingMember.class).map(sh -> this.getAssociationValues().contains(sh.getAssociationValue(event))).orElse(true));
    }

    public final Object handleSync(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        if (this.isActive) {
            return this.metaModel.findHandlerMethods(event, context).stream().filter(handler -> handler.unwrap(SagaMethodMessageHandlingMember.class).map(sh -> this.getAssociationValues().contains(sh.getAssociationValue(event))).orElse(true)).findFirst().map(handler -> this.handle((MessageHandlingMember<? super T>)handler, event, context)).orElse(null);
        }
        return null;
    }

    private Object handle(MessageHandlingMember<? super T> handler, EventMessage<?> event, ProcessingContext context) {
        try {
            return this.executeWithResult(() -> this.chainedInterceptor.handleSync((Message)event, context, this.sagaInstance, handler));
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SagaExecutionException("Exception while handling an Event in a Saga", e);
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public T root() {
        return this.sagaInstance;
    }

    @Override
    protected void doEnd() {
        this.isActive = false;
    }

    @Override
    protected void doAssociateWith(AssociationValue property) {
        this.associationValues.add(property);
    }

    @Override
    protected String type() {
        return this.sagaInstance.getClass().getSimpleName();
    }

    @Override
    protected void doRemoveAssociation(AssociationValue property) {
        this.associationValues.remove(property);
    }
}

