/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import jakarta.annotation.Nonnull;
import java.util.regex.Pattern;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class MethodCommandHandlerInterceptorDefinition
implements HandlerEnhancerDefinition {
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.attribute("CommandHandlerInterceptor.commandNamePattern").map(commandNamePattern -> new MethodCommandHandlerInterceptorHandlingMember(original, (String)commandNamePattern)).orElse(original);
    }

    private static class MethodCommandHandlerInterceptorHandlingMember<T>
    extends WrappedMessageHandlingMember<T> {
        private final Pattern commandNamePattern;

        private MethodCommandHandlerInterceptorHandlingMember(MessageHandlingMember<T> delegate, String commandNamePattern) {
            super(delegate);
            this.commandNamePattern = Pattern.compile(commandNamePattern);
        }

        public boolean canHandle(@Nonnull Message<?> message, @Nonnull ProcessingContext context) {
            return super.canHandle(message, context) && this.commandNamePattern.matcher(message.type().name()).matches();
        }
    }
}

