/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.command.AggregateMember;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.AnnotatedChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntityDefinition;
import org.axonframework.modelling.command.inspection.EntityModel;

public abstract class AbstractChildEntityDefinition
implements ChildEntityDefinition {
    @Override
    public <T> Optional<ChildEntity<T>> createChildDefinition(Member member, EntityModel<T> declaringEntity) {
        Map attributes = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)((AnnotatedElement)((Object)member)), AggregateMember.class).orElse(null);
        if (attributes == null || !this.isMemberTypeSupported(member)) {
            return Optional.empty();
        }
        EntityModel<Object> childEntityModel = this.extractChildEntityModel(declaringEntity, attributes, member);
        ForwardingMode<EventMessage<?>> eventForwardingMode = this.instantiateForwardingMode(member, childEntityModel, (Class)attributes.get("eventForwardingMode"));
        return Optional.of(new AnnotatedChildEntity<Object, Object>(childEntityModel, (Boolean)attributes.get("forwardCommands"), (msg, parent) -> this.resolveCommandTarget((CommandMessage<?>)msg, (Object)parent, member, childEntityModel), (msg, parent) -> this.resolveEventTargets((EventMessage)msg, (Object)parent, member, eventForwardingMode)));
    }

    protected abstract boolean isMemberTypeSupported(Member var1);

    protected abstract <T> EntityModel<Object> extractChildEntityModel(EntityModel<T> var1, Map<String, Object> var2, Member var3);

    private ForwardingMode<EventMessage<?>> instantiateForwardingMode(Member member, EntityModel<Object> childEntityModel, Class<? extends ForwardingMode<EventMessage<?>>> forwardingModeClass) {
        ForwardingMode<EventMessage<?>> forwardingMode;
        try {
            forwardingMode = forwardingModeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            forwardingMode.initialize(member, childEntityModel);
        }
        catch (ReflectiveOperationException e) {
            throw new AxonConfigurationException(String.format("Failed to instantiate ForwardingMode of type [%s].", forwardingModeClass));
        }
        return forwardingMode;
    }

    protected abstract <T> Object resolveCommandTarget(CommandMessage<?> var1, T var2, Member var3, EntityModel<Object> var4);

    protected Map<String, Property<Object>> extractCommandHandlerRoutingKeys(Member member, EntityModel<Object> childEntityModel) {
        return childEntityModel.commandHandlers(childEntityModel.entityClass()).map(commandHandler -> commandHandler.unwrap(CommandMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(CommandMessageHandlingMember::commandName, commandHandler -> this.extractCommandHandlerRoutingKey(childEntityModel, (CommandMessageHandlingMember<?>)commandHandler, member)));
    }

    private Property<Object> extractCommandHandlerRoutingKey(EntityModel<Object> childEntityModel, CommandMessageHandlingMember<?> commandHandler, Member member) {
        Class commandPayloadType = commandHandler.payloadType();
        String routingKey = (String)ObjectUtils.getOrDefault((Object)commandHandler.routingKey(), (Object)childEntityModel.routingKey());
        if (routingKey == null) {
            throw new AxonConfigurationException(String.format("Unable to route command of type [%s] since no routing key was defined. Either specify an entity id on the Aggregate Member [%s] or define a routing key on the command handler annotation", commandPayloadType, childEntityModel.entityClass()));
        }
        Property property = PropertyAccessStrategy.getProperty((Class)commandPayloadType, (String)routingKey);
        if (property == null) {
            throw new AxonConfigurationException(String.format("Command of type [%s] doesn't have a property matching the routing key [%s] necessary to route through member [%s]", commandPayloadType, routingKey, ReflectionUtils.getMemberGenericString((Member)member)));
        }
        return property;
    }

    protected abstract <T> Stream<Object> resolveEventTargets(EventMessage var1, T var2, Member var3, ForwardingMode var4);
}

