/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiFunction;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.EntityEvolver;

public class PayloadBasedEntityEvolver<P, E>
implements EntityEvolver<E> {
    private final Class<P> payloadType;
    private final BiFunction<E, P, E> evolver;

    public PayloadBasedEntityEvolver(@Nonnull Class<P> payloadType, @Nonnull BiFunction<E, P, E> evolver) {
        this.payloadType = Objects.requireNonNull(payloadType, "The payload type must not be null.");
        this.evolver = Objects.requireNonNull(evolver, "The evolver must not be null.");
    }

    @Override
    public E evolve(@Nonnull E entity, @Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        P payload = this.payloadType.cast(Objects.requireNonNull(event, "The event must not be null.").getPayload());
        return this.evolver.apply(Objects.requireNonNull(entity, "The entity must not be null."), payload);
    }
}

