/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.repository;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.repository.ManagedEntity;
import org.axonframework.modelling.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessSerializingRepository<ID, T>
implements Repository.LifecycleManagement<ID, T>,
DescribableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AccessSerializingRepository.class);
    private final Context.ResourceKey<ConcurrentMap<ID, CompletableFuture<ManagedEntity<ID, T>>>> workingEntitiesKey = Context.ResourceKey.withLabel((String)"workingEntities");
    private final Repository.LifecycleManagement<ID, T> delegate;
    private final ConcurrentMap<ID, CompletableFuture<ManagedEntity<ID, T>>> inProgress;

    public AccessSerializingRepository(Repository.LifecycleManagement<ID, T> delegate) {
        this.delegate = delegate;
        this.inProgress = new ConcurrentHashMap<ID, CompletableFuture<ManagedEntity<ID, T>>>();
    }

    @Override
    public ManagedEntity<ID, T> attach(@Nonnull ManagedEntity<ID, T> entity, @Nonnull ProcessingContext processingContext) {
        return this.delegate.attach(entity, processingContext);
    }

    @Override
    @Nonnull
    public Class<T> entityType() {
        return this.delegate.entityType();
    }

    @Override
    @Nonnull
    public Class<ID> idType() {
        return this.delegate.idType();
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, T>> load(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.awaitTurn(identifier, processingContext, () -> this.delegate.load(identifier, processingContext));
    }

    @Override
    public CompletableFuture<ManagedEntity<ID, T>> loadOrCreate(@Nonnull ID identifier, @Nonnull ProcessingContext processingContext) {
        return this.awaitTurn(identifier, processingContext, () -> this.delegate.loadOrCreate(identifier, processingContext));
    }

    private CompletableFuture<ManagedEntity<ID, T>> awaitTurn(ID identifier, ProcessingContext processingContext, Supplier<CompletableFuture<ManagedEntity<ID, T>>> entitySupplier) {
        CompletionStage previousTask;
        logger.info("Attempting to load [{}] in {}", identifier, (Object)processingContext);
        ConcurrentMap workingEntities = (ConcurrentMap)processingContext.computeResourceIfAbsent(this.workingEntitiesKey, ConcurrentHashMap::new);
        if (workingEntities.containsKey(identifier)) {
            logger.info("Found a working entity for [{}] in {}. Returning it.", identifier, (Object)processingContext);
            return (CompletableFuture)workingEntities.get(identifier);
        }
        CompletableFuture doneMarker = new CompletableFuture();
        CompletableFuture previousMarker = this.inProgress.put(identifier, doneMarker);
        doneMarker.whenComplete((r, e) -> this.inProgress.remove(identifier, doneMarker));
        if (previousMarker == null) {
            logger.info("No previous task found for loading [{}]. Performing actual load.", identifier);
            previousTask = FutureUtils.emptyCompletedFuture();
        } else {
            logger.info("Previous task detected. Will wait for it to complete before loading [{}] in {}", identifier, (Object)processingContext);
            previousTask = previousMarker.whenComplete((r, e) -> logger.info("Previous task completed. Processing {} in {}", new Object[]{r, processingContext, e}));
        }
        return ((CompletableFuture)((CompletableFuture)previousTask.exceptionally(e -> {
            logger.info("Previous task finished with exception", e);
            return null;
        })).thenCompose(previousEntity -> {
            CompletableFuture<ManagedEntity<ID, T>> workingEntity;
            if (previousEntity == null) {
                logger.info("Previous task for [{}] did not exist or completed with a failure. Loading from delegate in {}.", identifier, (Object)processingContext);
            } else {
                logger.info("Previous task finished successfully and transferred entity [{}] to {}.", identifier, (Object)processingContext);
            }
            if (previousEntity == null) {
                logger.info("Calling entity supplier in {} to load or create [{}].", (Object)processingContext, identifier);
                workingEntity = (CompletableFuture<ManagedEntity<ID, T>>)entitySupplier.get();
            } else {
                logger.info("Received [{}] in {}. Registering as managed instance.", identifier, (Object)processingContext);
                workingEntity = CompletableFuture.completedFuture(this.delegate.attach((ManagedEntity<ID, T>)previousEntity, processingContext));
            }
            workingEntities.put(identifier, workingEntity);
            return workingEntity.whenComplete((r, e) -> {
                logger.info("Entity [{}] released in {}", identifier, (Object)processingContext);
                processingContext.whenComplete(pc -> {
                    logger.info("Processing in {} completed successfully. Passing [{}] to next task.", (Object)processingContext, identifier);
                    doneMarker.complete(((CompletableFuture)workingEntities.get(identifier)).getNow(null));
                });
                processingContext.onError((pc, phase, error) -> {
                    logger.info("Processing in {} completed with error. Triggering next task to continue without [{}].", (Object)processingContext, identifier);
                    doneMarker.complete(null);
                });
            });
        })).thenApply(Function.identity());
    }

    @Override
    public ManagedEntity<ID, T> persist(@Nonnull ID identifier, @Nonnull T entity, @Nonnull ProcessingContext processingContext) {
        ManagedEntity<ID, T> persisted;
        ConcurrentMap workingEntities = (ConcurrentMap)processingContext.computeResourceIfAbsent(this.workingEntitiesKey, ConcurrentHashMap::new);
        if (workingEntities.put(identifier, CompletableFuture.completedFuture(persisted = this.delegate.persist(identifier, entity, processingContext))) == null) {
            CompletableFuture doneMarker = new CompletableFuture();
            this.inProgress.put(identifier, doneMarker);
            processingContext.whenComplete(pc -> ((CompletableFuture)workingEntities.get(identifier)).getNow(null));
            processingContext.onError((pc, phase, error) -> doneMarker.complete(null));
        }
        return persisted;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
    }
}

