/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.annotation.AnnotatedCommandHandlingComponent;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.ModuleBuilder;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.command.StatefulCommandHandler;
import org.axonframework.modelling.configuration.DefaultStatefulCommandHandlingModule;
import org.axonframework.modelling.configuration.EntityBuilder;

public interface StatefulCommandHandlingModule
extends Module,
ModuleBuilder<StatefulCommandHandlingModule> {
    public static SetupPhase named(@Nonnull String moduleName) {
        return new DefaultStatefulCommandHandlingModule(moduleName);
    }

    public static interface EntityPhase
    extends SetupPhase,
    ModuleBuilder<StatefulCommandHandlingModule> {
        public <I, E> EntityPhase entity(@Nonnull EntityBuilder<I, E> var1);
    }

    public static interface CommandHandlerPhase
    extends SetupPhase,
    ModuleBuilder<StatefulCommandHandlingModule> {
        default public CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull CommandHandler commandHandler) {
            Objects.requireNonNull(commandHandler, "The command handler cannot be null.");
            return this.commandHandler(commandName, (CommandMessage<?> command, StateManager state, ProcessingContext context) -> commandHandler.handle(command, context));
        }

        default public CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull StatefulCommandHandler commandHandler) {
            Objects.requireNonNull(commandName, "The command name cannot be null.");
            Objects.requireNonNull(commandHandler, "The stateful command handler cannot be null.");
            return this.commandHandler(commandName, (ComponentFactory<StatefulCommandHandler>)((ComponentFactory)c -> commandHandler));
        }

        public CommandHandlerPhase commandHandler(@Nonnull QualifiedName var1, @Nonnull ComponentFactory<StatefulCommandHandler> var2);

        public CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentFactory<CommandHandlingComponent> var1);

        default public CommandHandlerPhase annotatedCommandHandlingComponent(@Nonnull ComponentFactory<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.commandHandlingComponent((ComponentFactory<CommandHandlingComponent>)((ComponentFactory)c -> new AnnotatedCommandHandlingComponent(handlingComponentBuilder.build(c), (ParameterResolverFactory)c.getComponent(ParameterResolverFactory.class))));
        }
    }

    public static interface SetupPhase {
        public CommandHandlerPhase commandHandlers();

        default public CommandHandlerPhase commandHandlers(@Nonnull Consumer<CommandHandlerPhase> configurationLambda) {
            CommandHandlerPhase commandHandlerPhase = this.commandHandlers();
            Objects.requireNonNull(configurationLambda, "The command handler configuration lambda cannot be null.").accept(commandHandlerPhase);
            return commandHandlerPhase;
        }

        public EntityPhase entities();

        default public EntityPhase entities(@Nonnull Consumer<EntityPhase> configurationLambda) {
            EntityPhase entityPhase = this.entities();
            Objects.requireNonNull(configurationLambda, "The entity configuration lambda cannot be null.").accept(entityPhase);
            return entityPhase;
        }
    }
}

