/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.command.AggregateEntityNotFoundException;
import org.axonframework.modelling.command.inspection.AnnotatedCommandHandlerInterceptor;
import org.axonframework.modelling.command.inspection.ForwardingCommandMessageHandlingMember;

public class ChildForwardingCommandMessageHandlingMember<P, C>
implements ForwardingCommandMessageHandlingMember<P> {
    private final List<MessageHandlingMember<? super C>> childHandlingInterceptors;
    private final MessageHandlingMember<? super C> childHandler;
    private final BiFunction<CommandMessage<?>, P, C> childEntityResolver;
    private final String commandName;
    private final boolean isFactoryHandler;

    public ChildForwardingCommandMessageHandlingMember(List<MessageHandlingMember<? super C>> childHandlerInterceptors, MessageHandlingMember<? super C> childHandler, BiFunction<CommandMessage<?>, P, C> childEntityResolver) {
        this.childHandlingInterceptors = childHandlerInterceptors;
        this.childHandler = childHandler;
        this.childEntityResolver = childEntityResolver;
        this.commandName = childHandler.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::commandName).orElse(null);
        this.isFactoryHandler = childHandler.unwrap(CommandMessageHandlingMember.class).map(CommandMessageHandlingMember::isFactoryHandler).orElse(false);
    }

    public String commandName() {
        return this.commandName;
    }

    public String routingKey() {
        return null;
    }

    public boolean isFactoryHandler() {
        return this.isFactoryHandler;
    }

    public Class<?> payloadType() {
        return this.childHandler.payloadType();
    }

    public int priority() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean canForward(CommandMessage<?> message, P target) {
        return this.childEntityResolver.apply(message, target) != null;
    }

    public boolean canHandle(@Nonnull Message<?> message, ProcessingContext processingContext) {
        return this.childHandler.canHandle(message, processingContext);
    }

    public boolean canHandleMessageType(@Nonnull Class<? extends Message> messageType) {
        return this.childHandler.canHandleMessageType(messageType);
    }

    public Object handleSync(@Nonnull Message<?> message, @Nullable P target) throws Exception {
        Object childEntity = this.childEntityResolver.apply((CommandMessage)message, target);
        if (childEntity == null) {
            throw new AggregateEntityNotFoundException("Aggregate cannot handle command [" + String.valueOf(message.type()) + "], as there is no entity instance within the aggregate to forward it to.");
        }
        List interceptors = this.childHandlingInterceptors.stream().filter(chi -> chi.canHandle(message, null)).sorted((chi1, chi2) -> Integer.compare(chi2.priority(), chi1.priority())).map(chi -> new AnnotatedCommandHandlerInterceptor<Object>((MessageHandlingMember<Object>)chi, childEntity)).collect(Collectors.toList());
        Object result = interceptors.isEmpty() ? this.childHandler.handleSync(message, childEntity) : new DefaultInterceptorChain(CurrentUnitOfWork.get(), interceptors, m -> this.childHandler.handleSync(message, childEntity)).proceedSync();
        return result;
    }

    public <HT> Optional<HT> unwrap(Class<HT> handlerType) {
        if (handlerType.isInstance(this)) {
            return Optional.of(this);
        }
        return this.childHandler.unwrap(handlerType);
    }

    public <R> Optional<R> attribute(String attributeKey) {
        return this.childHandler.attribute(attributeKey);
    }
}

