/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.common.IdentifierValidator;
import org.axonframework.common.ListUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInvocationException;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.AggregateRoot;
import org.axonframework.modelling.command.AggregateVersion;
import org.axonframework.modelling.command.EntityId;
import org.axonframework.modelling.command.inspection.AggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AggregateModellingException;
import org.axonframework.modelling.command.inspection.ChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntityDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedAggregateMetaModelFactory
implements AggregateMetaModelFactory {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Class<?>, AnnotatedAggregateModel> registry;
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType) {
        return new AnnotatedAggregateMetaModelFactory().createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, Set<Class<? extends T>> subtypes) {
        return new AnnotatedAggregateMetaModelFactory().createModel(aggregateType, (Set)subtypes);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory).createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory, handlerDefinition).createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Set<Class<? extends T>> subtypes) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory, handlerDefinition).createModel(aggregateType, (Set)subtypes);
    }

    public AnnotatedAggregateMetaModelFactory() {
        this(ClasspathParameterResolverFactory.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory) {
        this(parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.handlerDefinition = handlerDefinition;
        this.registry = new ConcurrentHashMap();
    }

    public <T> AnnotatedAggregateModel<T> createModel(Class<? extends T> aggregateType, Set<Class<? extends T>> subtypes) {
        if (!this.registry.containsKey(aggregateType)) {
            AnnotatedHandlerInspector inspector = AnnotatedHandlerInspector.inspectType(aggregateType, (ParameterResolverFactory)this.parameterResolverFactory, (HandlerDefinition)this.handlerDefinition, subtypes);
            AnnotatedAggregateModel<T> model = new AnnotatedAggregateModel<T>(aggregateType, inspector);
            this.registry.put(aggregateType, model);
            model.initialize();
        }
        return this.registry.get(aggregateType).whenReadSafe();
    }

    private class AnnotatedAggregateModel<T>
    implements AggregateModel<T> {
        private static final String PERSISTENCE_ID = "jakarta.persistence.Id";
        private final Class<? extends T> inspectedType;
        private final Map<Class<?>, List<ChildEntity<T>>> children;
        private final AnnotatedHandlerInspector<T> handlerInspector;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlerInterceptors;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlers;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allEventHandlers;
        private final Map<String, Class<?>> types;
        private final Map<Class<?>, String> declaredTypes;
        private Member identifierMember;
        private Member versionMember;
        private String routingKey;
        private final ThreadLocal<Boolean> initializing = new ThreadLocal();
        private volatile boolean initialized;

        public AnnotatedAggregateModel(Class<? extends T> aggregateType, AnnotatedHandlerInspector<T> handlerInspector) {
            this.inspectedType = aggregateType;
            this.types = new HashMap();
            this.declaredTypes = new HashMap();
            this.allCommandHandlerInterceptors = new HashMap();
            this.allCommandHandlers = new HashMap();
            this.allEventHandlers = new HashMap();
            this.children = new HashMap();
            this.handlerInspector = handlerInspector;
        }

        private void initialize() {
            this.initializing.set(Boolean.TRUE);
            this.inspectFieldsAndMethods();
            this.inspectAggregateTypes();
            this.prepareHandlers();
            this.initialized = true;
            this.initializing.remove();
        }

        private void prepareHandlers() {
            Class type;
            for (Map.Entry handlersPerType : this.handlerInspector.getAllHandlers().entrySet()) {
                type = (Class)handlersPerType.getKey();
                for (MessageHandlingMember handler : (SortedSet)handlersPerType.getValue()) {
                    if (handler.unwrap(CommandMessageHandlingMember.class).isPresent()) {
                        if (Modifier.isAbstract(type.getModifiers()) && handler.unwrap(Constructor.class).isPresent()) {
                            throw new AggregateModellingException(String.format("An abstract aggregate %s cannot have @CommandHandler on constructor.", type));
                        }
                        this.addHandler(this.allCommandHandlers, type, handler);
                        continue;
                    }
                    this.addHandler(this.allEventHandlers, type, handler);
                }
            }
            for (Map.Entry interceptorsPerType : this.handlerInspector.getAllInterceptors().entrySet()) {
                type = (Class)interceptorsPerType.getKey();
                for (MessageHandlingMember handler : (SortedSet)interceptorsPerType.getValue()) {
                    this.addHandler(this.allCommandHandlerInterceptors, type, handler);
                }
            }
            this.prepareChildEntityCommandHandlers();
            this.validateCommandHandlers();
        }

        private void prepareChildEntityCommandHandlers() {
            Iterator<Class<?>> iterator = this.types.values().iterator();
            while (iterator.hasNext()) {
                Class<?> aggregateType;
                Class<?> type = aggregateType = iterator.next();
                ArrayList childrenPerType = new ArrayList(this.children.getOrDefault(type, Collections.emptyList()));
                while (!type.equals(Object.class) && type.getSuperclass() != null) {
                    type = type.getSuperclass();
                    childrenPerType.addAll(new ArrayList(this.children.getOrDefault(type, Collections.emptyList())));
                }
                for (ChildEntity child : childrenPerType) {
                    child.commandHandlers().forEach(childCommandHandler -> this.addHandler(this.allCommandHandlers, aggregateType, (MessageHandlingMember<? super T>)childCommandHandler));
                }
            }
        }

        private void addHandler(Map<Class<?>, List<MessageHandlingMember<? super T>>> handlers, Class<?> type, MessageHandlingMember<? super T> handler) {
            handlers.computeIfAbsent(type, t -> new ArrayList()).add(handler);
        }

        private void validateCommandHandlers() {
            ArrayList<List<MessageHandlingMember<T>>> handlers = new ArrayList<List<MessageHandlingMember<T>>>(this.allCommandHandlers.values());
            for (int i = 0; i < handlers.size() - 1; ++i) {
                List<CommandMessageHandlingMember<T>> factoryCommands1 = this.factoryCommands((List)handlers.get(i));
                List<CommandMessageHandlingMember<T>> factoryCommands2 = this.factoryCommands((List)handlers.get(i + 1));
                for (CommandMessageHandlingMember<T> handler1 : factoryCommands1) {
                    for (CommandMessageHandlingMember<T> handler2 : factoryCommands2) {
                        Class declaringClass2;
                        Class declaringClass1;
                        String commandName2;
                        String commandName1 = handler1.commandName();
                        if (!commandName1.equals(commandName2 = handler2.commandName()) || (declaringClass1 = handler1.declaringClass()).equals(declaringClass2 = handler2.declaringClass())) continue;
                        throw new AggregateModellingException(String.format("Aggregates %s and %s have the same creation @CommandHandler %s", declaringClass1, declaringClass2, commandName1));
                    }
                }
            }
        }

        private List<CommandMessageHandlingMember<? super T>> factoryCommands(List<MessageHandlingMember<? super T>> handlers) {
            return handlers.stream().map(h -> h.unwrap(CommandMessageHandlingMember.class)).filter(Optional::isPresent).map(Optional::get).filter(CommandMessageHandlingMember::isFactoryHandler).map(h -> h).collect(Collectors.toList());
        }

        private void inspectAggregateTypes() {
            for (Class type : this.handlerInspector.getAllHandlers().keySet()) {
                String declaredType = this.findDeclaredType(type);
                this.types.put(declaredType, type);
                this.declaredTypes.put(type, declaredType);
            }
        }

        private String findDeclaredType(Class<?> type) {
            return AnnotationUtils.findAnnotationAttributes(type, AggregateRoot.class).map(map -> (String)map.get("type")).filter(i -> i.length() > 0).orElse(type.getSimpleName());
        }

        private void inspectFieldsAndMethods() {
            ServiceLoader<ChildEntityDefinition> childEntityDefinitions = ServiceLoader.load(ChildEntityDefinition.class, this.inspectedType.getClassLoader());
            ArrayList entityIdMembers = new ArrayList();
            ArrayList persistenceIdMembers = new ArrayList();
            ArrayList<Member> aggregateVersionMembers = new ArrayList<Member>();
            for (Class handledType : this.handlerInspector.getAllInspectedTypes()) {
                for (Field field : ReflectionUtils.fieldsOf((Class)handledType, (boolean)false)) {
                    this.createChildDefinitions(childEntityDefinitions, handledType, field);
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, EntityId.class).ifPresent(attributes -> entityIdMembers.add(field));
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, (String)PERSISTENCE_ID).ifPresent(attributes -> persistenceIdMembers.add(field));
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, AggregateVersion.class).ifPresent(attributes -> aggregateVersionMembers.add(field));
                }
                for (Method method : ReflectionUtils.methodsOf((Class)handledType, (boolean)false)) {
                    this.createChildDefinitions(childEntityDefinitions, handledType, method);
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, EntityId.class).ifPresent(attributes -> {
                        this.assertValidValueProvidingMethod(method, EntityId.class.getSimpleName());
                        entityIdMembers.add(method);
                    });
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, (String)PERSISTENCE_ID).ifPresent(attributes -> {
                        this.assertValidValueProvidingMethod(method, PERSISTENCE_ID);
                        persistenceIdMembers.add(method);
                    });
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)method, AggregateVersion.class).ifPresent(attributes -> {
                        this.assertValidValueProvidingMethod(method, AggregateVersion.class.getSimpleName());
                        aggregateVersionMembers.add(method);
                    });
                }
            }
            this.findIdentifierMember(ListUtils.distinct(entityIdMembers), ListUtils.distinct(persistenceIdMembers)).ifPresent(this::setIdentifierAndRoutingKey);
            this.setVersionMember(aggregateVersionMembers);
            this.assertIdentifierValidity(this.identifierMember);
        }

        private void createChildDefinitions(ServiceLoader<ChildEntityDefinition> childEntityDefinitions, Class<?> type, Member entityMember) {
            childEntityDefinitions.forEach(definition -> definition.createChildDefinition(entityMember, this).ifPresent(child -> this.children.computeIfAbsent(type, t -> new ArrayList()).add(child)));
        }

        private void assertValidValueProvidingMethod(Method method, String annotationName) {
            if (method.getParameterCount() != 0) {
                throw new AggregateModellingException(String.format("Aggregate [%s] has an [%s] annotated method [%s] with parameters, whilst none are allowed on such a method.", this.inspectedType, annotationName, method));
            }
            if (method.getReturnType() == Void.TYPE) {
                throw new AggregateModellingException(String.format("Aggregate [%s] has an [%s] annotated method [%s] with void return type, whilst a return value is required for such a method.", this.inspectedType, annotationName, method));
            }
        }

        private Optional<Member> findIdentifierMember(List<Member> entityIdMembers, List<Member> persistenceIdMembers) {
            if (entityIdMembers.size() > 1) {
                throw new AggregateModellingException(String.format("Aggregate [%s] has more than one identifier member, while only a single member is allowed.", this.inspectedType));
            }
            if (!entityIdMembers.isEmpty()) {
                return Optional.of(entityIdMembers.get(0));
            }
            if (!persistenceIdMembers.isEmpty()) {
                return Optional.of(persistenceIdMembers.get(0));
            }
            return Optional.empty();
        }

        private void setIdentifierAndRoutingKey(Member identifier) {
            this.identifierMember = identifier;
            this.routingKey = this.findRoutingKey((AccessibleObject)((Object)identifier)).orElseGet(() -> this.getMemberIdentifierName(identifier));
        }

        private Optional<String> findRoutingKey(AccessibleObject accessibleObject) {
            return AnnotationUtils.findAnnotationAttribute((AnnotatedElement)accessibleObject, EntityId.class, (String)"routingKey").filter(key -> !"".equals(key));
        }

        private String getMemberIdentifierName(Member identifierMember) {
            String identifierName = identifierMember.getName();
            return identifierMember instanceof Method && this.isGetterByConvention(identifierName) ? this.stripGetterConvention(identifierName) : identifierName;
        }

        private boolean isGetterByConvention(String identifierName) {
            return identifierName.startsWith("get") && identifierName.length() >= 4 && Character.isUpperCase(identifierName.charAt(3));
        }

        private String stripGetterConvention(String identifierName) {
            return identifierName.substring(3, 4).toLowerCase() + identifierName.substring(4);
        }

        private void setVersionMember(List<Member> versionMembers) {
            if (versionMembers.isEmpty()) {
                logger.debug("No @AggregateVersion annotated Member found.");
                return;
            }
            if (versionMembers.size() > 1) {
                String versionMembersString = versionMembers.stream().map(Member::getName).collect(Collectors.joining(", "));
                throw new AggregateModellingException(String.format("Aggregate [%s] has two or more @AggregateVersion annotated members, whilst only a single member is allowed.\n The following version members have been found: %s", this.inspectedType, versionMembersString));
            }
            logger.debug("@AggregateVersion annotated Member [{}] has been found and set as the [{}] Aggregate Version.", (Object)versionMembers.get(0).getName(), this.inspectedType);
            this.versionMember = versionMembers.get(0);
        }

        private void assertIdentifierValidity(Member identifier) {
            if (identifier != null) {
                Class idClazz = ReflectionUtils.getMemberValueType((Member)identifier);
                if (!IdentifierValidator.getInstance().isValidIdentifier(idClazz)) {
                    throw new AggregateModellingException(String.format("Aggregate identifier type [%s] should override Object.toString()", idClazz.getName()));
                }
            }
        }

        private AnnotatedAggregateModel<T> runtimeModelOf(T target) {
            return this.modelOf(target.getClass());
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlers() {
            return Collections.unmodifiableMap(this.allCommandHandlers);
        }

        @Override
        public Stream<MessageHandlingMember<? super T>> commandHandlers(Class<? extends T> subtype) {
            return this.handlers(this.allCommandHandlers, subtype);
        }

        @Override
        public Stream<Class<?>> types() {
            return this.handlerInspector.getAllHandlers().keySet().stream();
        }

        @Override
        public <C> AnnotatedAggregateModel<C> modelOf(Class<? extends C> childEntityType) {
            return AnnotatedAggregateMetaModelFactory.this.createModel(childEntityType, Collections.emptySet());
        }

        @Override
        public Class<? extends T> entityClass() {
            return this.inspectedType;
        }

        @Override
        public void publish(EventMessage<?> message, T target) {
            if (target != null) {
                this.runtimeModelOf(target).doPublish(message, target);
            }
        }

        private void doPublish(EventMessage<?> message, T target) {
            this.getHandler((Message<?>)message, target.getClass()).ifPresent(h -> {
                try {
                    this.handlerInspector.chainedInterceptor(target.getClass()).handleSync((Message)message, target, h);
                }
                catch (Exception e) {
                    throw new MessageHandlerInvocationException(String.format("Error handling event of type [%s] in aggregate", message.getPayloadType()), (Throwable)e);
                }
            });
            this.children.values().stream().flatMap(Collection::stream).forEach(childEntity -> childEntity.publish(message, target));
        }

        @Override
        public String type() {
            return this.declaredTypes.get(this.inspectedType);
        }

        @Override
        public Optional<Class<?>> type(String declaredType) {
            return Optional.ofNullable(this.types.getOrDefault(declaredType, null));
        }

        @Override
        public Optional<String> declaredType(Class<?> type) {
            return Optional.ofNullable(this.declaredTypes.getOrDefault(type, null));
        }

        @Override
        public Long getVersion(T target) {
            return this.versionMember != null ? (Long)ReflectionUtils.getMemberValue((Member)this.versionMember, target) : null;
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlerInterceptors() {
            return Collections.unmodifiableMap(this.allCommandHandlerInterceptors);
        }

        @Override
        public Stream<MessageHandlingMember<? super T>> commandHandlerInterceptors(Class<? extends T> subtype) {
            return this.handlers(this.allCommandHandlerInterceptors, subtype);
        }

        protected Optional<MessageHandlingMember<? super T>> getHandler(Message<?> message, Class<?> targetClass) {
            return this.handlers(this.allEventHandlers, targetClass).filter(handler -> handler.canHandle(message, null)).findFirst();
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allEventHandlers() {
            return Collections.unmodifiableMap(this.allEventHandlers);
        }

        private Stream<MessageHandlingMember<? super T>> handlers(Map<Class<?>, List<MessageHandlingMember<? super T>>> handlers, Class<?> subtype) {
            Class<?> type = subtype;
            while (!handlers.containsKey(type) && !Objects.equals(type, Object.class) && type.getSuperclass() != null) {
                type = type.getSuperclass();
            }
            return handlers.getOrDefault(type, Collections.emptyList()).stream();
        }

        @Override
        public Object getIdentifier(T target) {
            return this.identifierMember != null ? ReflectionUtils.getMemberValue((Member)this.identifierMember, target) : null;
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }

        private AnnotatedAggregateModel<T> whenReadSafe() {
            if (Boolean.TRUE.equals(this.initializing.get())) {
                return this;
            }
            while (!this.initialized) {
                Thread.yield();
            }
            return this;
        }
    }
}

