/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.reflect.Member;
import java.util.Map;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.command.ForwardingMode;
import org.axonframework.modelling.command.inspection.AbstractChildEntityDefinition;
import org.axonframework.modelling.command.inspection.EntityModel;

public class AggregateMemberAnnotatedChildEntityDefinition
extends AbstractChildEntityDefinition {
    @Override
    protected boolean isMemberTypeSupported(Member member) {
        try {
            Class valueType = ReflectionUtils.getMemberValueType((Member)member);
            return !Iterable.class.isAssignableFrom(valueType) && !Map.class.isAssignableFrom(valueType);
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    protected <T> EntityModel<Object> extractChildEntityModel(EntityModel<T> declaringEntity, Map<String, Object> attributes, Member member) {
        Class entityClass = ReflectionUtils.getMemberValueType((Member)member);
        if (entityClass.isInterface()) {
            throw new AxonConfigurationException("Aggregate Member type should be a concrete implementation instead of [" + String.valueOf(entityClass) + "].");
        }
        return declaringEntity.modelOf(entityClass);
    }

    @Override
    protected <T> Object resolveCommandTarget(CommandMessage<?> msg, T parent, Member member, EntityModel<Object> childEntityModel) {
        return ReflectionUtils.getMemberValue((Member)member, parent);
    }

    @Override
    protected <T> Stream<Object> resolveEventTargets(EventMessage message, T parentEntity, Member member, ForwardingMode eventForwardingMode) {
        Object memberValue = ReflectionUtils.getMemberValue((Member)member, parentEntity);
        return memberValue == null ? Stream.empty() : eventForwardingMode.filterCandidates(message, Stream.of(memberValue));
    }
}

