/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.axonframework.common.Assert;

public class VersionedAggregateIdentifier {
    private final Object identifier;
    private final Long version;

    public VersionedAggregateIdentifier(@Nonnull Object identifier, Long version) {
        Assert.notNull((Object)identifier, () -> "Identifier must not be null");
        this.identifier = identifier;
        this.version = version;
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier.toString();
    }

    @Nonnull
    public Object getIdentifierValue() {
        return this.identifier;
    }

    public Long getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedAggregateIdentifier that = (VersionedAggregateIdentifier)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.version);
    }
}

