/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.SimpleCommandHandlingComponent;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.command.StatefulCommandHandler;
import org.axonframework.modelling.command.StatefulCommandHandlerRegistry;

public class StatefulCommandHandlingComponent
implements CommandHandlingComponent,
StatefulCommandHandlerRegistry<StatefulCommandHandlingComponent>,
DescribableComponent {
    private final String name;
    private final SimpleCommandHandlingComponent handlingComponent;
    private final StateManager stateManager;

    public static StatefulCommandHandlingComponent create(@Nonnull String name, @Nonnull StateManager stateManager) {
        return new StatefulCommandHandlingComponent(name, stateManager);
    }

    private StatefulCommandHandlingComponent(@Nonnull String name, @Nonnull StateManager stateManager) {
        BuilderUtils.assertNonEmpty((String)name, (String)"The name may not be null or empty");
        this.name = name;
        this.stateManager = Objects.requireNonNull(stateManager, "StateManager may not be null");
        this.handlingComponent = SimpleCommandHandlingComponent.create((String)name);
    }

    @Override
    public StatefulCommandHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull StatefulCommandHandler commandHandler) {
        Objects.requireNonNull(name, "The name of the command handler may not be null");
        Objects.requireNonNull(commandHandler, "The command handler may not be null");
        this.handlingComponent.subscribe(name, (command, context) -> {
            try {
                return commandHandler.handle(command, this.stateManager, context);
            }
            catch (Throwable e) {
                return MessageStream.failed((Throwable)e);
            }
        });
        return this;
    }

    @Nonnull
    public MessageStream.Single<? extends CommandResultMessage<?>> handle(@Nonnull CommandMessage<?> command, @Nonnull ProcessingContext context) {
        return this.handlingComponent.handle(command, context);
    }

    public StatefulCommandHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        this.handlingComponent.subscribe(name, commandHandler);
        return this;
    }

    public Set<QualifiedName> supportedCommands() {
        return this.handlingComponent.supportedCommands();
    }

    public void describeTo(ComponentDescriptor descriptor) {
        descriptor.describeProperty("name", this.name);
        descriptor.describeProperty("handlingComponent", (Object)this.handlingComponent);
        descriptor.describeProperty("stateManager", (Object)this.stateManager);
    }
}

