/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.annotation.CommandMessageHandlingMember;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateCreationPolicy;
import org.axonframework.modelling.command.AnnotationCommandTargetResolver;
import org.axonframework.modelling.command.CommandTargetResolver;
import org.axonframework.modelling.command.CreationPolicyAggregateFactory;
import org.axonframework.modelling.command.IdentifierMissingException;
import org.axonframework.modelling.command.LegacyRepository;
import org.axonframework.modelling.command.NoArgumentConstructorCreationPolicyAggregateFactory;
import org.axonframework.modelling.command.VersionedAggregateIdentifier;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.CreationPolicyMember;

public class AggregateAnnotationCommandHandler<T>
implements CommandHandlingComponent {
    private final LegacyRepository<T> repository;
    private final CommandTargetResolver commandTargetResolver;
    private final List<MessageHandler<CommandMessage<?>, CommandResultMessage<?>>> handlers;
    private final Set<QualifiedName> supportedCommands;
    private final Map<String, Set<MessageHandler<CommandMessage<?>, CommandResultMessage<?>>>> supportedCommandsByName;
    private final Map<Class<? extends T>, CreationPolicyAggregateFactory<T>> factoryPerType;
    private final MessageTypeResolver messageTypeResolver;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    protected AggregateAnnotationCommandHandler(Builder<T> builder) {
        builder.validate();
        this.repository = builder.repository;
        this.commandTargetResolver = builder.commandTargetResolver;
        this.supportedCommands = new HashSet<QualifiedName>();
        this.supportedCommandsByName = new HashMap();
        this.messageTypeResolver = builder.messageTypeResolver;
        AggregateModel<T> aggregateModel = builder.buildAggregateModel();
        this.factoryPerType = this.initializeAggregateFactories(aggregateModel.types().map(type -> type).collect(Collectors.toList()), builder.creationPolicyAggregateFactory);
        this.handlers = this.initializeHandlers(aggregateModel);
    }

    private Map<Class<? extends T>, CreationPolicyAggregateFactory<T>> initializeAggregateFactories(List<Class<? extends T>> aggregateTypes, CreationPolicyAggregateFactory<T> configuredAggregateFactory) {
        HashMap<Class<T>, CreationPolicyAggregateFactory<T>> typeToFactory = new HashMap<Class<T>, CreationPolicyAggregateFactory<T>>();
        for (Class<T> clazz : aggregateTypes) {
            typeToFactory.put(clazz, configuredAggregateFactory != null ? configuredAggregateFactory : new NoArgumentConstructorCreationPolicyAggregateFactory<T>(clazz));
        }
        return typeToFactory;
    }

    private List<MessageHandler<CommandMessage<?>, CommandResultMessage<?>>> initializeHandlers(AggregateModel<T> aggregateModel) {
        ArrayList handlersFound = new ArrayList();
        aggregateModel.allCommandHandlers().values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(this::getHandlerSignature)).forEach((signature, commandHandlers) -> this.initializeHandler(aggregateModel, (MessageHandlingMember)commandHandlers.getFirst(), handlersFound));
        return handlersFound;
    }

    private String getHandlerSignature(MessageHandlingMember<? super T> handler) {
        return handler.unwrap(Executable.class).map(ReflectionUtils::toDiscernibleSignature).orElseThrow(() -> new IllegalStateException("A handler is missing an Executable. Please provide an Executable in your MessageHandlingMembers"));
    }

    private void initializeHandler(AggregateModel<T> aggregateModel, MessageHandlingMember<? super T> handler, List<MessageHandler<CommandMessage<?>, CommandResultMessage<?>>> handlersFound) {
        handler.unwrap(CommandMessageHandlingMember.class).ifPresent(cmh -> {
            Object messageHandler;
            Optional<AggregateCreationPolicy> policy = handler.unwrap(CreationPolicyMember.class).map(CreationPolicyMember::creationPolicy);
            if (cmh.isFactoryHandler()) {
                BuilderUtils.assertThat(policy, p -> p.map(AggregateCreationPolicy.ALWAYS::equals).orElse(true), (String)(aggregateModel.type() + ": Static methods/constructors can only use creationPolicy ALWAYS"));
                messageHandler = new AggregateConstructorCommandHandler(handler);
            } else {
                messageHandler = switch (policy.orElse(AggregateCreationPolicy.NEVER)) {
                    default -> throw new MatchException(null, null);
                    case AggregateCreationPolicy.ALWAYS -> new AlwaysCreateAggregateCommandHandler(handler, Optional.ofNullable(this.factoryPerType.get(handler.declaringClass())).orElse(this.factoryPerType.get(aggregateModel.entityClass())));
                    case AggregateCreationPolicy.CREATE_IF_MISSING -> new AggregateCreateOrUpdateCommandHandler(handler, Optional.ofNullable(this.factoryPerType.get(handler.declaringClass())).orElse(this.factoryPerType.get(aggregateModel.entityClass())));
                    case AggregateCreationPolicy.NEVER -> new AggregateCommandHandler(handler);
                };
            }
            handlersFound.add((MessageHandler<CommandMessage<?>, CommandResultMessage<?>>)messageHandler);
            this.supportedCommandsByName.computeIfAbsent(cmh.commandName(), key -> new HashSet()).add(messageHandler);
            this.supportedCommands.add(new QualifiedName(cmh.commandName()));
        });
    }

    @Nonnull
    public MessageStream.Single<CommandResultMessage<?>> handle(@Nonnull CommandMessage<?> message, @Nonnull ProcessingContext processingContext) {
        return this.handlers.stream().filter(ch -> ch.canHandle((Message)message)).findFirst().orElseThrow(() -> new NoHandlerForCommandException(message)).handle(message, processingContext).mapMessage(m -> AggregateAnnotationCommandHandler.asCommandResultMessage(m, arg_0 -> ((MessageTypeResolver)this.messageTypeResolver).resolve(arg_0))).first().cast();
    }

    private static <R> CommandResultMessage<R> asCommandResultMessage(@Nullable Object commandResult, @Nonnull Function<Object, MessageType> typeResolver) {
        if (commandResult instanceof CommandResultMessage) {
            return (CommandResultMessage)commandResult;
        }
        if (commandResult instanceof Message) {
            Message commandResultMessage = (Message)commandResult;
            return new GenericCommandResultMessage(commandResultMessage);
        }
        MessageType type = typeResolver.apply(ObjectUtils.nullSafeTypeOf((Object)commandResult));
        return new GenericCommandResultMessage(type, commandResult);
    }

    public boolean canHandle(CommandMessage<?> message) {
        return this.handlers.stream().anyMatch(ch -> ch.canHandle((Message)message));
    }

    protected Object resolveReturnValue(CommandMessage<?> command, Aggregate<T> createdAggregate) {
        return createdAggregate.identifier();
    }

    public Set<QualifiedName> supportedCommands() {
        return Set.copyOf(this.supportedCommands);
    }

    private VersionedAggregateIdentifier resolveNullableAggregateId(CommandMessage<?> command) {
        try {
            return this.commandTargetResolver.resolveTarget(command);
        }
        catch (IdentifierMissingException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("It does not identify the target aggregate.")) {
                return null;
            }
            throw e;
        }
    }

    private Object handleNewInstanceCreation(CommandMessage<?> command, CreationPolicyAggregateFactory<T> factoryMethod, MessageHandlingMember<? super T> handler, VersionedAggregateIdentifier commandMessageVersionedId) throws Exception {
        AtomicReference response = new AtomicReference();
        AtomicReference exceptionDuringInit = new AtomicReference();
        Object commandMessageAggregateId = Optional.ofNullable(commandMessageVersionedId).map(VersionedAggregateIdentifier::getIdentifierValue).orElse(null);
        Aggregate<Object> aggregate = this.repository.newInstance(() -> factoryMethod.create(commandMessageAggregateId), a -> {
            try {
                response.set(a.handle((Message<?>)command));
            }
            catch (Exception e) {
                exceptionDuringInit.set(e);
            }
        });
        if (exceptionDuringInit.get() != null) {
            throw (Exception)exceptionDuringInit.get();
        }
        return AggregateAnnotationCommandHandler.handlerHasVoidReturnType(handler) ? this.resolveReturnValue(command, aggregate) : response.get();
    }

    private static <T> boolean handlerHasVoidReturnType(MessageHandlingMember<? super T> handler) {
        return handler.unwrap(Method.class).map(Method::getReturnType).filter(Void.TYPE::equals).isPresent();
    }

    public static class Builder<T> {
        private LegacyRepository<T> repository;
        private CommandTargetResolver commandTargetResolver = AnnotationCommandTargetResolver.builder().build();
        private Class<T> aggregateType;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private AggregateModel<T> aggregateModel;
        private CreationPolicyAggregateFactory<T> creationPolicyAggregateFactory;
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public Builder<T> repository(LegacyRepository<T> repository) {
            BuilderUtils.assertNonNull(repository, (String)"Repository may not be null");
            this.repository = repository;
            return this;
        }

        public Builder<T> commandTargetResolver(CommandTargetResolver commandTargetResolver) {
            BuilderUtils.assertNonNull((Object)commandTargetResolver, (String)"CommandTargetResolver may not be null");
            this.commandTargetResolver = commandTargetResolver;
            return this;
        }

        public Builder<T> aggregateType(Class<T> aggregateType) {
            BuilderUtils.assertNonNull(aggregateType, (String)"The aggregateType may not be null");
            this.aggregateType = aggregateType;
            return this;
        }

        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder<T> aggregateModel(AggregateModel<T> aggregateModel) {
            BuilderUtils.assertNonNull(aggregateModel, (String)"AggregateModel may not be null");
            this.aggregateModel = aggregateModel;
            return this;
        }

        public Builder<T> creationPolicyAggregateFactory(CreationPolicyAggregateFactory<T> creationPolicyAggregateFactory) {
            this.creationPolicyAggregateFactory = creationPolicyAggregateFactory;
            return this;
        }

        public Builder<T> messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull((Object)messageTypeResolver, (String)"MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return this;
        }

        private AggregateModel<T> buildAggregateModel() {
            if (this.aggregateModel == null) {
                return this.inspectAggregateModel();
            }
            return this.aggregateModel;
        }

        private AggregateModel<T> inspectAggregateModel() {
            if (this.parameterResolverFactory == null) {
                this.parameterResolverFactory = ClasspathParameterResolverFactory.forClass(this.aggregateType);
            }
            return this.handlerDefinition == null ? AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, this.parameterResolverFactory) : AnnotatedAggregateMetaModelFactory.inspectAggregate(this.aggregateType, this.parameterResolverFactory, this.handlerDefinition);
        }

        public AggregateAnnotationCommandHandler<T> build() {
            return new AggregateAnnotationCommandHandler(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull(this.repository, (String)"The Repository is a hard requirement and should be provided");
            if (this.aggregateModel == null) {
                BuilderUtils.assertNonNull(this.aggregateType, (String)"No AggregateModel is set, whilst either it or the aggregateType is a hard requirement");
                return;
            }
            BuilderUtils.assertNonNull(this.aggregateModel, (String)"No aggregateType is set, whilst either it or the AggregateModel is a hard requirement");
        }
    }

    private class AggregateConstructorCommandHandler
    implements MessageHandler<CommandMessage<?>, CommandResultMessage<?>> {
        private final MessageHandlingMember<?> handler;

        public AggregateConstructorCommandHandler(MessageHandlingMember<?> handler) {
            this.handler = handler;
        }

        public Object handleSync(CommandMessage<?> command) throws Exception {
            Aggregate<Object> aggregate = AggregateAnnotationCommandHandler.this.repository.newInstance(() -> this.handler.handleSync((Message)command, null));
            return AggregateAnnotationCommandHandler.this.resolveReturnValue(command, aggregate);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message, null);
        }
    }

    private class AlwaysCreateAggregateCommandHandler
    implements MessageHandler<CommandMessage<?>, CommandResultMessage<?>> {
        private final MessageHandlingMember<? super T> handler;
        private final CreationPolicyAggregateFactory<T> factoryMethod;

        private AlwaysCreateAggregateCommandHandler(MessageHandlingMember<? super T> handler, CreationPolicyAggregateFactory<T> factoryMethod) {
            this.handler = handler;
            this.factoryMethod = factoryMethod;
        }

        public Object handleSync(CommandMessage<?> command) throws Exception {
            return AggregateAnnotationCommandHandler.this.handleNewInstanceCreation(command, this.factoryMethod, this.handler, AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command));
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message, null);
        }
    }

    private class AggregateCreateOrUpdateCommandHandler
    implements MessageHandler<CommandMessage<?>, CommandResultMessage<?>> {
        private final MessageHandlingMember<? super T> handler;
        private final CreationPolicyAggregateFactory<T> factoryMethod;

        public AggregateCreateOrUpdateCommandHandler(MessageHandlingMember<? super T> handler, CreationPolicyAggregateFactory<T> factoryMethod) {
            this.handler = handler;
            this.factoryMethod = factoryMethod;
        }

        public Object handleSync(CommandMessage<?> command) throws Exception {
            Object result;
            VersionedAggregateIdentifier versionedAggregateIdentifier = AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command);
            if (versionedAggregateIdentifier != null) {
                Aggregate<Object> instance = AggregateAnnotationCommandHandler.this.repository.loadOrCreate(versionedAggregateIdentifier.getIdentifier(), () -> this.factoryMethod.create(versionedAggregateIdentifier.getIdentifierValue()));
                result = instance.handle((Message<?>)command);
            } else {
                result = AggregateAnnotationCommandHandler.this.handleNewInstanceCreation(command, this.factoryMethod, this.handler, AggregateAnnotationCommandHandler.this.resolveNullableAggregateId(command));
            }
            return result;
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message, null);
        }
    }

    private class AggregateCommandHandler
    implements MessageHandler<CommandMessage<?>, CommandResultMessage<?>> {
        private final MessageHandlingMember<? super T> handler;

        public AggregateCommandHandler(MessageHandlingMember<? super T> handler) {
            this.handler = handler;
        }

        public Object handleSync(CommandMessage<?> command) throws Exception {
            VersionedAggregateIdentifier iv = AggregateAnnotationCommandHandler.this.commandTargetResolver.resolveTarget(command);
            return AggregateAnnotationCommandHandler.this.repository.load(iv.getIdentifier(), iv.getVersion()).handle((Message<?>)command);
        }

        public boolean canHandle(CommandMessage<?> message) {
            return this.handler.canHandle(message, null);
        }
    }
}

