/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.configuration.Configuration;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.modelling.StateManager;
import org.axonframework.modelling.annotation.NullEntityIdInPayloadException;
import org.axonframework.modelling.command.EntityIdResolver;

class InjectEntityParameterResolver
implements ParameterResolver<Object> {
    private final Configuration configuration;
    private final Class<?> type;
    private final EntityIdResolver<?> identifierResolver;
    private final boolean managedEntity;

    public InjectEntityParameterResolver(@Nonnull Configuration configuration, @Nonnull Class<?> type, @Nonnull EntityIdResolver<?> identifierResolver, boolean managedEntity) {
        this.configuration = Objects.requireNonNull(configuration, "The Configuration is required");
        this.type = Objects.requireNonNull(type, "The type is required");
        this.identifierResolver = Objects.requireNonNull(identifierResolver, "The ModelIdentifierResolver is required");
        this.managedEntity = managedEntity;
    }

    public Object resolveParameterValue(Message<?> message, ProcessingContext processingContext) {
        Object resolvedId = this.identifierResolver.resolve(message, processingContext);
        if (resolvedId == null) {
            throw new NullEntityIdInPayloadException(message.getPayload().getClass());
        }
        StateManager stateManager = (StateManager)this.configuration.getComponent(StateManager.class);
        if (this.managedEntity) {
            return stateManager.loadManagedEntity(this.type, resolvedId, processingContext).join();
        }
        return stateManager.loadEntity(this.type, resolvedId, processingContext).join();
    }

    public boolean matches(Message<?> message, ProcessingContext processingContext) {
        return true;
    }
}

