/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga.repository.jpa;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import javax.persistence.Basic;
import javax.persistence.Lob;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

@Entity
@javax.persistence.Entity
public class SagaEntry<T> {
    @Id
    @javax.persistence.Id
    protected String sagaId;
    @jakarta.persistence.Basic
    @Basic
    protected String sagaType;
    @jakarta.persistence.Basic
    @Basic
    protected String revision;
    @jakarta.persistence.Lob
    @Column(length=10000)
    @Lob
    @javax.persistence.Column(length=10000)
    protected byte[] serializedSaga;

    public SagaEntry(T saga, String sagaIdentifier, Serializer serializer) {
        this.sagaId = sagaIdentifier;
        SerializedObject serialized = serializer.serialize(saga, byte[].class);
        this.serializedSaga = (byte[])serialized.getData();
        this.sagaType = serialized.getType().getName();
        this.revision = serialized.getType().getRevision();
    }

    protected SagaEntry() {
    }

    public byte[] getSerializedSaga() {
        return this.serializedSaga;
    }

    public String getSagaId() {
        return this.sagaId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getSagaType() {
        return this.sagaType;
    }
}

