/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command.inspection;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandMessageHandlingMember;
import org.axonframework.common.IdentifierValidator;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInvocationException;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.command.AggregateRoot;
import org.axonframework.modelling.command.AggregateVersion;
import org.axonframework.modelling.command.EntityId;
import org.axonframework.modelling.command.inspection.AggregateMetaModelFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AggregateModellingException;
import org.axonframework.modelling.command.inspection.ChildEntity;
import org.axonframework.modelling.command.inspection.ChildEntityDefinition;
import org.axonframework.modelling.command.inspection.CommandHandlerInterceptorHandlingMember;

public class AnnotatedAggregateMetaModelFactory
implements AggregateMetaModelFactory {
    private final Map<Class<?>, AnnotatedAggregateModel> registry;
    private final ParameterResolverFactory parameterResolverFactory;
    private final HandlerDefinition handlerDefinition;

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType) {
        return new AnnotatedAggregateMetaModelFactory().createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, Set<Class<? extends T>> subtypes) {
        return new AnnotatedAggregateMetaModelFactory().createModel(aggregateType, (Set)subtypes);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory).createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory, handlerDefinition).createModel(aggregateType);
    }

    public static <T> AggregateModel<T> inspectAggregate(Class<T> aggregateType, ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition, Set<Class<? extends T>> subtypes) {
        return new AnnotatedAggregateMetaModelFactory(parameterResolverFactory, handlerDefinition).createModel(aggregateType, (Set)subtypes);
    }

    public AnnotatedAggregateMetaModelFactory() {
        this(ClasspathParameterResolverFactory.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory) {
        this(parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader()));
    }

    public AnnotatedAggregateMetaModelFactory(ParameterResolverFactory parameterResolverFactory, HandlerDefinition handlerDefinition) {
        this.parameterResolverFactory = parameterResolverFactory;
        this.handlerDefinition = handlerDefinition;
        this.registry = new ConcurrentHashMap();
    }

    public <T> AnnotatedAggregateModel<T> createModel(Class<? extends T> aggregateType, Set<Class<? extends T>> subtypes) {
        if (!this.registry.containsKey(aggregateType)) {
            AnnotatedHandlerInspector inspector = AnnotatedHandlerInspector.inspectType(aggregateType, (ParameterResolverFactory)this.parameterResolverFactory, (HandlerDefinition)this.handlerDefinition, subtypes);
            AnnotatedAggregateModel<? extends T> model = new AnnotatedAggregateModel<T>(aggregateType, inspector);
            this.registry.put(aggregateType, model);
            ((AnnotatedAggregateModel)model).initialize();
        }
        return this.registry.get(aggregateType).whenReadSafe();
    }

    private class AnnotatedAggregateModel<T>
    implements AggregateModel<T> {
        private final Class<? extends T> inspectedType;
        private final List<ChildEntity<T>> children;
        private final AnnotatedHandlerInspector<T> handlerInspector;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlerInterceptors;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlers;
        private final Map<Class<?>, List<MessageHandlingMember<? super T>>> allEventHandlers;
        private final Map<String, Class<?>> types;
        private final Map<Class<?>, String> declaredTypes;
        private Field identifierField;
        private Field versionField;
        private String routingKey;
        private final ThreadLocal<Boolean> initializing = new ThreadLocal();
        private volatile boolean initialized;

        public AnnotatedAggregateModel(Class<? extends T> aggregateType, AnnotatedHandlerInspector<T> handlerInspector) {
            this.inspectedType = aggregateType;
            this.types = new HashMap();
            this.declaredTypes = new HashMap();
            this.allCommandHandlerInterceptors = new HashMap();
            this.allCommandHandlers = new HashMap();
            this.allEventHandlers = new HashMap();
            this.children = new ArrayList<ChildEntity<T>>();
            this.handlerInspector = handlerInspector;
        }

        private void initialize() {
            this.initializing.set(Boolean.TRUE);
            this.inspectFields();
            this.prepareHandlers();
            this.inspectAggregateTypes();
            this.initialized = true;
            this.initializing.remove();
        }

        private void prepareHandlers() {
            for (Map.Entry handlersPerType : this.handlerInspector.getAllHandlers().entrySet()) {
                Class type = (Class)handlersPerType.getKey();
                for (MessageHandlingMember handler : (SortedSet)handlersPerType.getValue()) {
                    if (handler.unwrap(CommandMessageHandlingMember.class).isPresent()) {
                        if (Modifier.isAbstract(type.getModifiers()) && handler.unwrap(Constructor.class).isPresent()) {
                            throw new AggregateModellingException(String.format("An abstract aggregate %s cannot have @CommandHandler on constructor.", type));
                        }
                        this.addHandler(this.allCommandHandlers, type, handler);
                        continue;
                    }
                    if (handler.unwrap(CommandHandlerInterceptorHandlingMember.class).isPresent()) {
                        this.addHandler(this.allCommandHandlerInterceptors, type, handler);
                        continue;
                    }
                    this.addHandler(this.allEventHandlers, type, handler);
                }
            }
            this.validateCommandHandlers();
        }

        private void addHandler(Map<Class<?>, List<MessageHandlingMember<? super T>>> handlers, Class<?> type, MessageHandlingMember<? super T> handler) {
            handlers.compute(type, (key, value) -> {
                if (value == null) {
                    ArrayList<MessageHandlingMember> hs = new ArrayList<MessageHandlingMember>();
                    hs.add(handler);
                    return hs;
                }
                value.add(handler);
                return value;
            });
        }

        private void validateCommandHandlers() {
            ArrayList<List<MessageHandlingMember<T>>> handlers = new ArrayList<List<MessageHandlingMember<T>>>(this.allCommandHandlers.values());
            for (int i = 0; i < handlers.size() - 1; ++i) {
                List<CommandMessageHandlingMember<T>> factoryCommands1 = this.factoryCommands((List)handlers.get(i));
                List<CommandMessageHandlingMember<T>> factoryCommands2 = this.factoryCommands((List)handlers.get(i + 1));
                for (CommandMessageHandlingMember<T> handler1 : factoryCommands1) {
                    for (CommandMessageHandlingMember<T> handler2 : factoryCommands2) {
                        Class declaringClass2;
                        Class declaringClass1;
                        String commandName2;
                        String commandName1 = handler1.commandName();
                        if (!commandName1.equals(commandName2 = handler2.commandName()) || (declaringClass1 = handler1.declaringClass()).equals(declaringClass2 = handler2.declaringClass())) continue;
                        throw new AggregateModellingException(String.format("Aggregates %s and %s have the same creation @CommandHandler %s", declaringClass1, declaringClass2, commandName1));
                    }
                }
            }
        }

        private List<CommandMessageHandlingMember<? super T>> factoryCommands(List<MessageHandlingMember<? super T>> handlers) {
            return handlers.stream().map(h -> h.unwrap(CommandMessageHandlingMember.class)).filter(Optional::isPresent).map(Optional::get).filter(CommandMessageHandlingMember::isFactoryHandler).map(h -> h).collect(Collectors.toList());
        }

        private void inspectAggregateTypes() {
            for (Class type : this.handlerInspector.getAllHandlers().keySet()) {
                String declaredType = this.findDeclaredType(type);
                this.types.put(declaredType, type);
                this.declaredTypes.put(type, declaredType);
            }
        }

        private String findDeclaredType(Class<?> type) {
            return AnnotationUtils.findAnnotationAttributes(type, AggregateRoot.class).map(map -> (String)map.get("type")).filter(i -> i.length() > 0).orElse(type.getSimpleName());
        }

        private void inspectFields() {
            ServiceLoader<ChildEntityDefinition> childEntityDefinitions = ServiceLoader.load(ChildEntityDefinition.class, this.inspectedType.getClassLoader());
            boolean persistenceId = false;
            for (Class type : this.handlerInspector.getAllHandlers().keySet()) {
                for (Field field : ReflectionUtils.fieldsOf((Class)type)) {
                    childEntityDefinitions.forEach(def -> def.createChildDefinition(field, this).ifPresent(child -> {
                        this.children.add((ChildEntity<T>)child);
                        child.commandHandlers().forEach(handler -> this.addHandler(this.allCommandHandlers, type, (MessageHandlingMember<? super T>)handler));
                    }));
                    if (AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, EntityId.class).isPresent()) {
                        if (this.identifierField != null && !field.equals(this.identifierField) && !persistenceId) {
                            throw new AggregateModellingException(String.format("Aggregate [%s] has two identifier fields [%s] and [%s].", this.inspectedType, this.identifierField, field));
                        }
                        persistenceId = false;
                        this.identifierField = field;
                        Map attributes2 = (Map)AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, EntityId.class).get();
                        this.routingKey = !"".equals(attributes2.get("routingKey")) ? (String)attributes2.get("routingKey") : field.getName();
                    }
                    if (this.identifierField == null && AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, (String)"javax.persistence.Id").isPresent()) {
                        persistenceId = true;
                        this.identifierField = field;
                        this.routingKey = field.getName();
                    }
                    AnnotationUtils.findAnnotationAttributes((AnnotatedElement)field, AggregateVersion.class).ifPresent(attributes -> {
                        if (this.versionField != null && !field.equals(this.versionField)) {
                            throw new AggregateModellingException(String.format("Aggregate [%s] has two version fields [%s] and [%s].", this.inspectedType, this.versionField, field));
                        }
                        this.versionField = field;
                    });
                }
            }
            if (this.identifierField != null) {
                Class<?> idClazz = this.identifierField.getType();
                if (!IdentifierValidator.getInstance().isValidIdentifier(idClazz)) {
                    throw new AggregateModellingException(String.format("Aggregate identifier type [%s] should override Object.toString()", idClazz.getName()));
                }
            }
        }

        private AnnotatedAggregateModel<T> runtimeModelOf(T target) {
            return this.modelOf(target.getClass());
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlers() {
            return Collections.unmodifiableMap(this.allCommandHandlers);
        }

        @Override
        public Stream<MessageHandlingMember<? super T>> commandHandlers(Class<? extends T> subtype) {
            return this.handlers(this.allCommandHandlers, subtype);
        }

        @Override
        public Stream<Class<?>> types() {
            return this.handlerInspector.getAllHandlers().keySet().stream();
        }

        @Override
        public <C> AnnotatedAggregateModel<C> modelOf(Class<? extends C> childEntityType) {
            return AnnotatedAggregateMetaModelFactory.this.createModel(childEntityType, Collections.emptySet());
        }

        @Override
        public Class<? extends T> entityClass() {
            return this.inspectedType;
        }

        @Override
        public void publish(EventMessage<?> message, T target) {
            if (target != null) {
                super.doPublish(message, target);
            }
        }

        private void doPublish(EventMessage<?> message, T target) {
            this.getHandler((Message<?>)message, target.getClass()).ifPresent(h -> {
                try {
                    h.handle((Message)message, target);
                }
                catch (Exception e) {
                    throw new MessageHandlerInvocationException(String.format("Error handling event of type [%s] in aggregate", message.getPayloadType()), (Throwable)e);
                }
            });
            this.children.forEach(i -> i.publish(message, target));
        }

        @Override
        public String type() {
            return this.declaredTypes.get(this.inspectedType);
        }

        @Override
        public Optional<Class<?>> type(String declaredType) {
            return Optional.ofNullable(this.types.getOrDefault(declaredType, null));
        }

        @Override
        public Optional<String> declaredType(Class<?> type) {
            return Optional.ofNullable(this.declaredTypes.getOrDefault(type, null));
        }

        @Override
        public Long getVersion(T target) {
            if (this.versionField != null) {
                return (Long)ReflectionUtils.getFieldValue((Field)this.versionField, target);
            }
            return null;
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allCommandHandlerInterceptors() {
            return Collections.unmodifiableMap(this.allCommandHandlerInterceptors);
        }

        @Override
        public Stream<MessageHandlingMember<? super T>> commandHandlerInterceptors(Class<? extends T> subtype) {
            return this.handlers(this.allCommandHandlerInterceptors, subtype);
        }

        protected Optional<MessageHandlingMember<? super T>> getHandler(Message<?> message, Class<?> targetClass) {
            return this.handlers(this.allEventHandlers, targetClass).filter(handler -> handler.canHandle(message)).findAny();
        }

        @Override
        public Map<Class<?>, List<MessageHandlingMember<? super T>>> allEventHandlers() {
            return Collections.unmodifiableMap(this.allEventHandlers);
        }

        private Stream<MessageHandlingMember<? super T>> handlers(Map<Class<?>, List<MessageHandlingMember<? super T>>> handlers, Class<?> subtype) {
            Class<?> type = subtype;
            while (!handlers.containsKey(type) && !type.equals(Object.class)) {
                type = type.getSuperclass();
            }
            return ((List)handlers.getOrDefault(type, new ArrayList())).stream();
        }

        @Override
        public Object getIdentifier(T target) {
            if (this.identifierField != null) {
                return ReflectionUtils.getFieldValue((Field)this.identifierField, target);
            }
            return null;
        }

        @Override
        public String routingKey() {
            return this.routingKey;
        }

        private AnnotatedAggregateModel<T> whenReadSafe() {
            if (Boolean.TRUE.equals(this.initializing.get())) {
                return this;
            }
            while (!this.initialized) {
                Thread.yield();
            }
            return this;
        }
    }
}

