/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.command;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.common.lock.Lock;
import org.axonframework.messaging.Message;
import org.axonframework.modelling.command.Aggregate;

public class LockAwareAggregate<AR, A extends Aggregate<AR>>
implements Aggregate<AR> {
    private final A wrappedAggregate;
    private final LockSupplier lock;

    public LockAwareAggregate(A wrappedAggregate, Lock lock) {
        this.wrappedAggregate = wrappedAggregate;
        this.lock = () -> lock;
    }

    public LockAwareAggregate(A wrappedAggregate, Supplier<Lock> lock) {
        this.wrappedAggregate = wrappedAggregate;
        this.lock = lock::get;
    }

    public A getWrappedAggregate() {
        return this.wrappedAggregate;
    }

    public boolean isLockHeld() {
        return this.lock.acquire().isHeld();
    }

    @Override
    public String type() {
        return this.wrappedAggregate.type();
    }

    @Override
    public Object identifier() {
        return this.wrappedAggregate.identifier();
    }

    @Override
    public Long version() {
        return this.wrappedAggregate.version();
    }

    @Override
    public Object handle(Message<?> message) throws Exception {
        Object result = this.wrappedAggregate.handle(message);
        this.lock.acquire();
        return result;
    }

    @Override
    public <R> R invoke(Function<AR, R> invocation) {
        R result = this.wrappedAggregate.invoke(invocation);
        this.lock.acquire();
        return result;
    }

    @Override
    public void execute(Consumer<AR> invocation) {
        try {
            this.wrappedAggregate.execute(invocation);
        }
        finally {
            this.lock.acquire();
        }
    }

    @Override
    public boolean isDeleted() {
        return this.wrappedAggregate.isDeleted();
    }

    @Override
    public Class<? extends AR> rootType() {
        return this.wrappedAggregate.rootType();
    }

    @FunctionalInterface
    private static interface LockSupplier
    extends Supplier<Lock> {
        default public Lock acquire() {
            return (Lock)this.get();
        }
    }
}

