/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageCountingMonitor
implements MessageMonitor<Message<?>> {
    private final Counter ingestedCounter;
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Counter processedCounter;
    private final Counter ignoredCounter;

    private MessageCountingMonitor(Counter ingestedCounter, Counter successCounter, Counter failureCounter, Counter processedCounter, Counter ignoredCounter) {
        this.ingestedCounter = ingestedCounter;
        this.successCounter = successCounter;
        this.failureCounter = failureCounter;
        this.processedCounter = processedCounter;
        this.ignoredCounter = ignoredCounter;
    }

    public static MessageCountingMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        Counter ingestedCounter = meterRegistry.counter(meterNamePrefix + ".ingestedCounter", new String[0]);
        Counter successCounter = meterRegistry.counter(meterNamePrefix + ".successCounter", new String[0]);
        Counter failureCounter = meterRegistry.counter(meterNamePrefix + ".failureCounter", new String[0]);
        Counter processedCounter = meterRegistry.counter(meterNamePrefix + ".processedCounter", new String[0]);
        Counter ignoredCounter = meterRegistry.counter(meterNamePrefix + ".ignoredCounter", new String[0]);
        return new MessageCountingMonitor(ingestedCounter, successCounter, failureCounter, processedCounter, ignoredCounter);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        this.ingestedCounter.increment();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                MessageCountingMonitor.this.processedCounter.increment();
                MessageCountingMonitor.this.successCounter.increment();
            }

            public void reportFailure(Throwable cause) {
                MessageCountingMonitor.this.processedCounter.increment();
                MessageCountingMonitor.this.failureCounter.increment();
            }

            public void reportIgnored() {
                MessageCountingMonitor.this.ignoredCounter.increment();
            }
        };
    }
}

