/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MessageTimerMonitor
implements MessageMonitor<Message<?>>,
MetricSet {
    private final Timer allTimer;
    private final Timer successTimer;
    private final Timer failureTimer;
    private final Timer ignoredTimer;

    public static Builder builder() {
        return new Builder();
    }

    protected MessageTimerMonitor(Builder builder) {
        builder.validate();
        Clock clock = builder.clock;
        Supplier reservoirFactory = builder.reservoirFactory;
        this.allTimer = new Timer((Reservoir)reservoirFactory.get(), clock);
        this.successTimer = new Timer((Reservoir)reservoirFactory.get(), clock);
        this.failureTimer = new Timer((Reservoir)reservoirFactory.get(), clock);
        this.ignoredTimer = new Timer((Reservoir)reservoirFactory.get(), clock);
    }

    @Deprecated
    public MessageTimerMonitor() {
        this(Clock.defaultClock());
    }

    @Deprecated
    public MessageTimerMonitor(Clock clock) {
        this.allTimer = new Timer((Reservoir)new ExponentiallyDecayingReservoir(), clock);
        this.successTimer = new Timer((Reservoir)new ExponentiallyDecayingReservoir(), clock);
        this.failureTimer = new Timer((Reservoir)new ExponentiallyDecayingReservoir(), clock);
        this.ignoredTimer = new Timer((Reservoir)new ExponentiallyDecayingReservoir(), clock);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        final Timer.Context allTimerContext = this.allTimer.time();
        final Timer.Context successTimerContext = this.successTimer.time();
        final Timer.Context failureTimerContext = this.failureTimer.time();
        final Timer.Context ignoredTimerContext = this.ignoredTimer.time();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                allTimerContext.stop();
                successTimerContext.stop();
            }

            public void reportFailure(Throwable cause) {
                allTimerContext.stop();
                failureTimerContext.stop();
            }

            public void reportIgnored() {
                allTimerContext.stop();
                ignoredTimerContext.stop();
            }
        };
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("allTimer", (Metric)this.allTimer);
        metrics.put("successTimer", (Metric)this.successTimer);
        metrics.put("failureTimer", (Metric)this.failureTimer);
        metrics.put("ignoredTimer", (Metric)this.ignoredTimer);
        return metrics;
    }

    public static class Builder {
        private Clock clock = Clock.defaultClock();
        private Supplier<Reservoir> reservoirFactory = ExponentiallyDecayingReservoir::new;

        public Builder clock(Clock clock) {
            BuilderUtils.assertNonNull((Object)clock, (String)"Clock may not be null");
            this.clock = clock;
            return this;
        }

        public Builder reservoirFactory(Supplier<Reservoir> reservoirFactory) {
            BuilderUtils.assertNonNull(reservoirFactory, (String)"ReservoirFactory may not be null");
            this.reservoirFactory = reservoirFactory;
            return this;
        }

        public MessageTimerMonitor build() {
            return new MessageTimerMonitor(this);
        }

        protected void validate() {
        }
    }
}

