/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class PayloadTypeMessageMonitorWrapper<T extends MessageMonitor<Message<?>> & MetricSet>
implements MessageMonitor<Message<?>>,
MetricSet {
    private final Supplier<T> monitorSupplier;
    private final Function<Class<?>, String> monitorNameBuilder;
    private final Map<String, T> payloadTypeMonitors;
    private final Map<String, Metric> metricSet;

    PayloadTypeMessageMonitorWrapper(Supplier<T> monitorSupplier) {
        this(monitorSupplier, Class::getName);
    }

    public PayloadTypeMessageMonitorWrapper(Supplier<T> monitorSupplier, Function<Class<?>, String> monitorNameBuilder) {
        this.monitorSupplier = monitorSupplier;
        this.monitorNameBuilder = monitorNameBuilder;
        this.payloadTypeMonitors = new ConcurrentHashMap<String, T>();
        this.metricSet = Collections.unmodifiableMap(this.payloadTypeMonitors);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        String monitorName = this.monitorNameBuilder.apply(message.getPayloadType());
        MessageMonitor messageMonitorForPayloadType = this.payloadTypeMonitors.computeIfAbsent(monitorName, payloadType -> (MessageMonitor)this.monitorSupplier.get());
        return messageMonitorForPayloadType.onMessageIngested(message);
    }

    public Map<String, Metric> getMetrics() {
        return this.metricSet;
    }
}

