/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring.interceptors;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageDispatchInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.monitoring.MessageMonitor;

public class MonitoringEventDispatchInterceptor
implements MessageDispatchInterceptor<EventMessage> {
    private final MessageMonitor<? super EventMessage> messageMonitor;

    public MonitoringEventDispatchInterceptor(@Nonnull MessageMonitor<? super EventMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull EventMessage message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<EventMessage> interceptorChain) {
        if (context != null && context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

