/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;

public class TransactionalUnitOfWorkFactory
implements UnitOfWorkFactory {
    private final TransactionManager transactionManager;
    private final UnitOfWorkFactory delegate;

    public TransactionalUnitOfWorkFactory(@Nonnull TransactionManager transactionManager, @Nonnull UnitOfWorkFactory delegate) {
        Objects.requireNonNull(transactionManager, "Transaction Manager cannot be null");
        Objects.requireNonNull(delegate, "Delegate UnitOfWorkFactory cannot be null");
        this.transactionManager = transactionManager;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public UnitOfWork create(@Nonnull String identifier, @Nonnull UnaryOperator<UnitOfWorkConfiguration> customization) {
        UnitOfWork unitOfWork = this.delegate.create(identifier, customization);
        Context.ResourceKey transactionResourceKey = Context.ResourceKey.withLabel("transaction");
        unitOfWork.runOnPreInvocation(ctx -> {
            Transaction transaction = this.transactionManager.startTransaction();
            ctx.putResource(transactionResourceKey, transaction);
        });
        unitOfWork.runOnCommit(ctx -> {
            Transaction transaction = (Transaction)ctx.getResource(transactionResourceKey);
            transaction.commit();
        });
        unitOfWork.onError((ctx, phase, error) -> {
            Transaction transaction = (Transaction)ctx.getResource(transactionResourceKey);
            transaction.rollback();
        });
        return unitOfWork;
    }
}

