/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.retry;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.retry.RetryPolicy;

public class MaxAttemptsPolicy
implements RetryPolicy {
    private final RetryPolicy delegate;
    private final int maxAttempts;

    public MaxAttemptsPolicy(RetryPolicy delegate, int retries) {
        this.delegate = delegate;
        this.maxAttempts = retries;
    }

    @Override
    public RetryPolicy.Outcome defineFor(@Nonnull Message message, @Nonnull Throwable cause, @Nonnull List<Class<? extends Throwable>[]> previousFailures) {
        if (previousFailures.size() < this.maxAttempts) {
            return this.delegate.defineFor(message, cause, previousFailures);
        }
        return RetryPolicy.Outcome.doNotReschedule();
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("maxAttempts", this.maxAttempts);
    }
}

