/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.axonframework.messaging.annotations.MultiParameterResolverFactory;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathParameterResolverFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathParameterResolverFactory.class);
    private static final Object monitor = new Object();
    private static final Map<ClassLoader, WeakReference<ParameterResolverFactory>> FACTORIES = new WeakHashMap<ClassLoader, WeakReference<ParameterResolverFactory>>();

    private ClasspathParameterResolverFactory() {
    }

    public static ParameterResolverFactory forClass(Class<?> clazz) {
        return ClasspathParameterResolverFactory.forClassLoader(clazz == null ? null : clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParameterResolverFactory forClassLoader(ClassLoader classLoader) {
        Object object = monitor;
        synchronized (object) {
            if (!FACTORIES.containsKey(classLoader)) {
                MultiParameterResolverFactory factory = MultiParameterResolverFactory.ordered(ClasspathParameterResolverFactory.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<MultiParameterResolverFactory>(factory));
                return factory;
            }
            ParameterResolverFactory factory = (ParameterResolverFactory)FACTORIES.get(classLoader).get();
            if (factory == null) {
                factory = MultiParameterResolverFactory.ordered(ClasspathParameterResolverFactory.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<ParameterResolverFactory>(factory));
            }
            return factory;
        }
    }

    private static List<ParameterResolverFactory> findDelegates(ClassLoader classLoader) {
        Iterator<ParameterResolverFactory> iterator = ServiceLoader.load(ParameterResolverFactory.class, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).iterator();
        ArrayList<ParameterResolverFactory> factories = new ArrayList<ParameterResolverFactory>();
        while (iterator.hasNext()) {
            try {
                ParameterResolverFactory factory = iterator.next();
                factories.add(factory);
            }
            catch (ServiceConfigurationError e) {
                logger.info("ParameterResolverFactory instance ignored, as one of the required classes is not availableon the classpath: {}", (Object)e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                logger.info("ParameterResolverFactory instance ignored. It relies on a class that cannot be found: {}", (Object)e.getMessage());
            }
        }
        return factories;
    }
}

