/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class EmptyMessageStream
implements MessageStream.Empty<Message> {
    private static final EmptyMessageStream INSTANCE = new EmptyMessageStream();

    private EmptyMessageStream() {
    }

    public static MessageStream.Empty<Message> instance() {
        return INSTANCE;
    }

    @Override
    public CompletableFuture<MessageStream.Entry<Message>> asCompletableFuture() {
        return FutureUtils.emptyCompletedFuture();
    }

    @Override
    public Optional<MessageStream.Entry<Message>> next() {
        return Optional.empty();
    }

    @Override
    public void setCallback(@Nonnull Runnable callback) {
        callback.run();
    }

    @Override
    public Optional<Throwable> error() {
        return Optional.empty();
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public boolean hasNextAvailable() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<Message>, R> accumulator) {
        return CompletableFuture.completedFuture(identity);
    }

    @Override
    public MessageStream<Message> onErrorContinue(@Nonnull Function<Throwable, MessageStream<Message>> onError) {
        return this;
    }

    @Override
    public MessageStream.Empty<Message> onComplete(@Nonnull Runnable completeHandler) {
        try {
            completeHandler.run();
            return this;
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    @Override
    public Optional<MessageStream.Entry<Message>> peek() {
        return Optional.empty();
    }
}

