/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.lifecycle;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.axonframework.lifecycle.ShutdownInProgressException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownLatch {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicInteger operationCounter = new AtomicInteger(0);
    private final AtomicReference<CompletableFuture<Void>> latch = new AtomicReference();

    public void initialize() {
        CompletableFuture existingLatch = this.latch.getAndSet(null);
        if (existingLatch != null) {
            logger.warn("Latch is being initialized whilst already shutting down");
            existingLatch.cancel(true);
        }
    }

    public ActivityHandle registerActivity() {
        this.ifShuttingDown(ShutdownInProgressException::new);
        int counter = this.operationCounter.getAndIncrement();
        if (counter == 0 && this.latch.get() != null) {
            this.operationCounter.getAndDecrement();
            throw new ShutdownInProgressException();
        }
        return new ActivityHandle();
    }

    public void ifShuttingDown(String exceptionMessage) {
        this.ifShuttingDown(() -> new ShutdownInProgressException(exceptionMessage));
    }

    public void ifShuttingDown(Supplier<RuntimeException> exceptionSupplier) {
        if (this.isShuttingDown()) {
            throw exceptionSupplier.get();
        }
    }

    public boolean isShuttingDown() {
        return this.latch.get() != null;
    }

    public CompletableFuture<Void> initiateShutdown() {
        CompletableFuture<Void> newLatch = new CompletableFuture<Void>();
        CompletableFuture<Void> existingLatch = this.latch.getAndUpdate(previous -> previous == null ? newLatch : previous);
        if (existingLatch == null) {
            if (this.operationCounter.get() == 0) {
                newLatch.complete(null);
            }
            return newLatch;
        }
        return existingLatch;
    }

    public class ActivityHandle
    implements AutoCloseable {
        private final AtomicBoolean ended = new AtomicBoolean(false);

        public void end() {
            CompletableFuture<Void> currentLatch;
            boolean firstInvocation = this.ended.compareAndSet(false, true);
            if (firstInvocation && ShutdownLatch.this.operationCounter.decrementAndGet() <= 0 && (currentLatch = ShutdownLatch.this.latch.get()) != null) {
                currentLatch.complete(null);
            }
        }

        @Override
        public void close() {
            this.end();
        }
    }
}

